/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple;
import com.arjuna.ats.jta.xa.XidImple;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<Xid, AtomicReference<SubordinateTransaction>> _transactions = new ConcurrentHashMap();

    @Override
    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return this.importTransaction(xid, 0);
    }

    @Override
    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        return this.addImportedTransaction(null, new XidImple(xid), xid, timeout);
    }

    @Override
    public SubordinateTransaction recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        TransactionImple recovered = new TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException();
        }
        return this.addImportedTransaction(recovered, recovered.baseXid(), null, 0);
    }

    @Override
    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        SubordinateTransaction tx2;
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        AtomicReference<SubordinateTransaction> holder = _transactions.get(new XidImple(xid));
        SubordinateTransaction subordinateTransaction = tx2 = holder == null ? null : holder.get();
        if (tx2 == null) {
            return null;
        }
        if (tx2.baseXid() == null) {
            tx2.recover();
            return tx2;
        }
        return tx2;
    }

    @Override
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        _transactions.remove(new XidImple(xid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubordinateTransaction addImportedTransaction(TransactionImple importedTransaction, Xid importedXid, Xid xid, int timeout) {
        SubordinateTransaction txn;
        AtomicReference<SubordinateTransaction> holder = new AtomicReference<SubordinateTransaction>();
        AtomicReference existing = _transactions.putIfAbsent(importedXid, holder);
        if (existing != null) {
            holder = existing;
        }
        if ((txn = (SubordinateTransaction)holder.get()) == null) {
            AtomicReference<SubordinateTransaction> atomicReference = holder;
            synchronized (atomicReference) {
                txn = (SubordinateTransaction)holder.get();
                if (txn == null) {
                    if (importedTransaction != null) {
                        importedTransaction.recordTransaction();
                        txn = importedTransaction;
                    } else {
                        txn = new TransactionImple(timeout, xid);
                    }
                    holder.set(txn);
                }
            }
        }
        return txn;
    }
}

