/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;

public class TaskContext {
    private EmbeddedCacheManager cacheManager;
    private Optional<Marshaller> marshaller = Optional.empty();
    private Optional<Cache<?, ?>> cache = Optional.empty();
    private Optional<Map<String, ?>> parameters = Optional.empty();
    private Optional<Subject> subject = Optional.empty();
    private boolean logEvent;

    public TaskContext cacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public TaskContext marshaller(Marshaller marshaller) {
        this.marshaller = Optional.of(marshaller);
        return this;
    }

    public TaskContext cache(Cache<?, ?> cache) {
        this.cache = Optional.of(cache);
        return this;
    }

    public TaskContext parameters(Map<String, ?> parameters) {
        this.parameters = Optional.of(parameters);
        return this;
    }

    public TaskContext subject(Subject subject) {
        this.subject = Optional.ofNullable(subject);
        return this;
    }

    public TaskContext addParameter(String name, Object value) {
        Map params = this.parameters.orElseGet(() -> new HashMap());
        params.put(name, value);
        return this.parameters(params);
    }

    public TaskContext logEvent(boolean logEvent) {
        this.logEvent = logEvent;
        return this;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Optional<Marshaller> getMarshaller() {
        return this.marshaller;
    }

    public Optional<Cache<?, ?>> getCache() {
        return this.cache;
    }

    public Optional<Map<String, ?>> getParameters() {
        return this.parameters;
    }

    public Optional<Subject> getSubject() {
        return this.subject;
    }

    public boolean isLogEvent() {
        return this.logEvent;
    }

    public String toString() {
        return "TaskContext{marshaller=" + this.marshaller + ", cache=" + this.cache + ", parameters=" + this.parameters + ", subject=" + this.subject + ", logEvent=" + this.logEvent + '}';
    }
}

