/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.nio.channels.FileLock;
import org.apache.activemq.artemis.core.io.aio.ActiveMQFileLock;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.jlibaio.LibaioFile;

public final class AIOFileLockNodeManager
extends FileLockNodeManager {
    public AIOFileLockNodeManager(File directory, boolean replicatingBackup) {
        super(directory, replicatingBackup);
    }

    public AIOFileLockNodeManager(File directory, boolean replicatingBackup, long lockAcquisitionTimeout) {
        super(directory, replicatingBackup);
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    @Override
    protected FileLock tryLock(int lockPos) throws Exception {
        File file = this.newFileForRegionLock(lockPos);
        LibaioFile fileControl = LibaioContext.openControlFile((String)file.getAbsolutePath(), (boolean)false);
        if (!fileControl.lock()) {
            fileControl.close();
            return null;
        }
        ActiveMQFileLock lock = new ActiveMQFileLock(fileControl);
        return lock;
    }

    @Override
    protected FileLock lock(int liveLockPos) throws Exception {
        long start = System.currentTimeMillis();
        File file = this.newFileForRegionLock(liveLockPos);
        while (!this.interrupted) {
            FileLock lockFile = this.tryLock(liveLockPos);
            if (lockFile != null) {
                return lockFile;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (this.lockAcquisitionTimeout == -1L || System.currentTimeMillis() - start <= this.lockAcquisitionTimeout) continue;
            throw new Exception("timed out waiting for lock");
        }
        return null;
    }

    protected File newFileForRegionLock(int liveLockPos) {
        File file = this.newFile("server." + liveLockPos + ".lock");
        return file;
    }
}

