/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchEnvironment;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexWorkVisitor;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.BarrierElasticsearchWorkOrchestrator;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaDropper;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.IndexNameNormalizer;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.Closer;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexManager
implements IndexManager,
IndexNameNormalizer {
    static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private String indexName;
    private URLEncodedString actualIndexName;
    private boolean refreshAfterWrite;
    private boolean sync;
    private IndexSchemaManagementStrategy schemaManagementStrategy;
    private ExecutionOptions schemaManagementExecutionOptions;
    private Similarity similarity;
    private ExtendedSearchIntegrator searchIntegrator;
    private IndexedTypeSet containedEntityTypes = IndexedTypeSets.empty();
    private boolean indexInitialized = false;
    private boolean indexCreatedByHibernateSearch = false;
    private IndexedTypeSet initializedContainedEntityTypes = IndexedTypeSets.empty();
    private ServiceManager serviceManager;
    private ElasticsearchService elasticsearchService;
    private ElasticsearchIndexWorkVisitor visitor;
    private ElasticsearchWorkProcessor workProcessor;
    private BarrierElasticsearchWorkOrchestrator nonStreamOrchestrator;

    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.indexName = indexName;
        this.schemaManagementStrategy = ElasticsearchIndexManager.getIndexManagementStrategy(properties);
        final ElasticsearchIndexStatus requiredIndexStatus = ElasticsearchIndexManager.getRequiredIndexStatus(properties);
        final int indexManagementWaitTimeout = ElasticsearchIndexManager.getIndexManagementWaitTimeout(properties);
        final boolean multitenancyEnabled = context.isMultitenancyEnabled();
        final DynamicType dynamicMapping = ElasticsearchIndexManager.getDynamicMapping(properties);
        this.schemaManagementExecutionOptions = new ExecutionOptions(){

            @Override
            public ElasticsearchIndexStatus getRequiredIndexStatus() {
                return requiredIndexStatus;
            }

            @Override
            public int getIndexManagementTimeoutInMs() {
                return indexManagementWaitTimeout;
            }

            @Override
            public boolean isMultitenancyEnabled() {
                return multitenancyEnabled;
            }

            @Override
            public DynamicType getDynamicMapping() {
                return dynamicMapping;
            }
        };
        String overriddenIndexName = ElasticsearchIndexManager.getOverriddenIndexName(indexName, properties);
        this.actualIndexName = ElasticsearchIndexNameNormalizer.getElasticsearchIndexName(overriddenIndexName);
        this.refreshAfterWrite = ElasticsearchIndexManager.getRefreshAfterWrite(properties);
        this.sync = BackendFactory.isConfiguredAsSync((Properties)properties);
        this.similarity = similarity;
        this.elasticsearchService = (ElasticsearchService)this.serviceManager.requestService(ElasticsearchService.class);
        this.visitor = new ElasticsearchIndexWorkVisitor(this.actualIndexName, this.refreshAfterWrite, context.getUninitializedSearchIntegrator(), this.elasticsearchService.getWorkFactory());
        this.workProcessor = this.elasticsearchService.getWorkProcessor();
        this.nonStreamOrchestrator = this.workProcessor.createNonStreamOrchestrator(indexName, this.refreshAfterWrite);
    }

    public ElasticsearchService getElasticsearchService() {
        return this.elasticsearchService;
    }

    private static String getOverriddenIndexName(String indexName, Properties properties) {
        String name = properties.getProperty("indexName");
        return name != null ? name : indexName;
    }

    private static IndexSchemaManagementStrategy getIndexManagementStrategy(Properties properties) {
        String propertyValue = properties.getProperty("elasticsearch.index_schema_management_strategy");
        if (StringHelper.isNotEmpty((String)propertyValue)) {
            return IndexSchemaManagementStrategy.interpretPropertyValue(propertyValue);
        }
        return ElasticsearchEnvironment.Defaults.INDEX_SCHEMA_MANAGEMENT_STRATEGY;
    }

    private static int getIndexManagementWaitTimeout(Properties properties) {
        int timeout = ConfigurationParseHelper.getIntValue((Properties)properties, (String)"elasticsearch.index_management_wait_timeout", (int)10000);
        if (timeout < 0) {
            throw LOG.negativeTimeoutValue(timeout);
        }
        return timeout;
    }

    private static DynamicType getDynamicMapping(Properties properties) {
        String status = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.dynamic_mapping", (String)ElasticsearchEnvironment.Defaults.DYNAMIC_MAPPING.name());
        return DynamicType.valueOf(status.toUpperCase(Locale.ROOT));
    }

    private static ElasticsearchIndexStatus getRequiredIndexStatus(Properties properties) {
        String status = ConfigurationParseHelper.getString((Properties)properties, (String)"elasticsearch.required_index_status", null);
        if (status == null) {
            return ElasticsearchEnvironment.Defaults.REQUIRED_INDEX_STATUS;
        }
        return ElasticsearchIndexStatus.fromString(status);
    }

    private static boolean getRefreshAfterWrite(Properties properties) {
        return ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"elasticsearch.refresh_after_write", (boolean)false);
    }

    public void destroy() {
        try (Closer closer = new Closer();){
            closer.push(this::awaitCompletion, (Object)this.nonStreamOrchestrator);
            if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.DROP_AND_CREATE_AND_DROP) {
                closer.push(() -> this.elasticsearchService.getSchemaDropper().dropIfExisting(this.actualIndexName, this.schemaManagementExecutionOptions));
            }
            closer.push(this.nonStreamOrchestrator::close);
            this.workProcessor = null;
            this.visitor = null;
            this.elasticsearchService = null;
            closer.push(arg_0 -> ((ServiceManager)this.serviceManager).releaseService(arg_0), ElasticsearchService.class);
            this.schemaManagementExecutionOptions = null;
            this.serviceManager = null;
        }
    }

    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.searchIntegrator = boundSearchIntegrator;
        this.initializeIndex();
    }

    private void initializeIndex() {
        if (!this.indexInitialized) {
            this.indexCreatedByHibernateSearch = this.initializeIndex(this.containedEntityTypes);
            this.indexInitialized = true;
            this.initializedContainedEntityTypes = IndexedTypeSets.composite((IndexedTypeSet)this.initializedContainedEntityTypes, (IndexedTypeSet)this.containedEntityTypes);
        } else {
            IndexedTypeSet notYetInitializedContainedEntityTypes = IndexedTypeSets.subtraction((IndexedTypeSet)this.containedEntityTypes, (IndexedTypeSet)this.initializedContainedEntityTypes);
            if (notYetInitializedContainedEntityTypes.isEmpty()) {
                return;
            }
            this.reinitializeIndex(notYetInitializedContainedEntityTypes);
            this.initializedContainedEntityTypes = IndexedTypeSets.composite((IndexedTypeSet)this.initializedContainedEntityTypes, (IndexedTypeSet)notYetInitializedContainedEntityTypes);
        }
    }

    private boolean initializeIndex(IndexedTypeSet entityTypesToInitialize) {
        boolean createdIndex;
        if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.NONE) {
            return false;
        }
        ElasticsearchSchemaCreator schemaCreator = this.elasticsearchService.getSchemaCreator();
        IndexMetadata indexMetadata = this.createIndexMetadata(entityTypesToInitialize);
        switch (this.schemaManagementStrategy) {
            case CREATE: {
                createdIndex = schemaCreator.createIndexIfAbsent(indexMetadata, this.schemaManagementExecutionOptions);
                if (!createdIndex) break;
                schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case DROP_AND_CREATE: 
            case DROP_AND_CREATE_AND_DROP: {
                ElasticsearchSchemaDropper schemaDropper = this.elasticsearchService.getSchemaDropper();
                schemaDropper.dropIfExisting(this.actualIndexName, this.schemaManagementExecutionOptions);
                schemaCreator.createIndex(indexMetadata, this.schemaManagementExecutionOptions);
                schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                createdIndex = true;
                break;
            }
            case UPDATE: {
                createdIndex = schemaCreator.createIndexIfAbsent(indexMetadata, this.schemaManagementExecutionOptions);
                if (createdIndex) {
                    schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                    break;
                }
                ElasticsearchSchemaMigrator schemaMigrator = this.elasticsearchService.getSchemaMigrator();
                schemaMigrator.migrate(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case VALIDATE: {
                ElasticsearchSchemaValidator schemaValidator = this.elasticsearchService.getSchemaValidator();
                schemaCreator.checkIndexExists(this.actualIndexName, this.schemaManagementExecutionOptions);
                schemaValidator.validate(indexMetadata, this.schemaManagementExecutionOptions);
                createdIndex = false;
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected schema management strategy: " + (Object)((Object)this.schemaManagementStrategy));
            }
        }
        return createdIndex;
    }

    private void reinitializeIndex(IndexedTypeSet entityTypesToInitialize) {
        if (this.schemaManagementStrategy == IndexSchemaManagementStrategy.NONE) {
            return;
        }
        ElasticsearchSchemaCreator schemaCreator = this.elasticsearchService.getSchemaCreator();
        IndexMetadata indexMetadata = this.createIndexMetadata(entityTypesToInitialize);
        switch (this.schemaManagementStrategy) {
            case CREATE: {
                if (!this.indexCreatedByHibernateSearch) break;
                schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case DROP_AND_CREATE: 
            case DROP_AND_CREATE_AND_DROP: {
                schemaCreator.createMappings(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case UPDATE: {
                ElasticsearchSchemaMigrator schemaMigrator = this.elasticsearchService.getSchemaMigrator();
                schemaMigrator.migrate(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            case VALIDATE: {
                ElasticsearchSchemaValidator schemaValidator = this.elasticsearchService.getSchemaValidator();
                schemaValidator.validate(indexMetadata, this.schemaManagementExecutionOptions);
                break;
            }
            default: {
                throw new AssertionFailure("Unexpected schema management strategy: " + (Object)((Object)this.schemaManagementStrategy));
            }
        }
    }

    private IndexMetadata createIndexMetadata(IndexedTypeSet entityTypes) {
        ArrayList<EntityIndexBinding> descriptors = new ArrayList<EntityIndexBinding>();
        for (IndexedTypeIdentifier entityType : entityTypes) {
            EntityIndexBinding descriptor = this.searchIntegrator.getIndexBinding(entityType);
            descriptors.add(descriptor);
        }
        ElasticsearchSchemaTranslator schemaTranslator = this.elasticsearchService.getSchemaTranslator();
        return schemaTranslator.translate(this.actualIndexName, descriptors, this.schemaManagementExecutionOptions);
    }

    public void addContainedEntity(IndexedTypeIdentifier entity) {
        this.containedEntityTypes = IndexedTypeSets.composite((IndexedTypeSet)this.containedEntityTypes, (IndexedTypeIdentifier)entity);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ReaderProvider getReaderProvider() {
        throw LOG.indexManagerReaderProviderUnsupported();
    }

    public IndexedTypeSet getContainedTypes() {
        return this.containedEntityTypes;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchIntegrator.getAnalyzer(name);
    }

    public LuceneWorkSerializer getSerializer() {
        return null;
    }

    public void flushAndReleaseResources() {
        Object flushWork = this.elasticsearchService.getWorkFactory().flush().index(this.actualIndexName).build();
        this.awaitCompletion(this.nonStreamOrchestrator);
        this.awaitCompletion(this.workProcessor.getStreamOrchestrator());
        this.nonStreamOrchestrator.submit((ElasticsearchWork<?>)flushWork).join();
    }

    public String getActualIndexName() {
        return this.actualIndexName.original;
    }

    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        ArrayList elasticsearchWorks = new ArrayList(workList.size());
        for (LuceneWork luceneWork : workList) {
            elasticsearchWorks.add((ElasticsearchWork<?>)luceneWork.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)monitor));
        }
        CompletableFuture<Void> future = this.nonStreamOrchestrator.submit(elasticsearchWorks);
        if (this.sync) {
            future.join();
        }
    }

    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        ElasticsearchWork elasticsearchWork = (ElasticsearchWork)singleOperation.acceptIndexWorkVisitor((IndexWorkVisitor)this.visitor, (Object)monitor);
        if (singleOperation instanceof FlushLuceneWork) {
            this.awaitAsyncProcessingCompletion();
            this.workProcessor.getStreamOrchestrator().submit(elasticsearchWork).join();
        } else {
            this.workProcessor.getStreamOrchestrator().submit(elasticsearchWork);
        }
    }

    public void awaitAsyncProcessingCompletion() {
        if (!this.sync) {
            this.awaitCompletion(this.nonStreamOrchestrator);
        }
        this.awaitCompletion(this.workProcessor.getStreamOrchestrator());
    }

    private void awaitCompletion(BarrierElasticsearchWorkOrchestrator orchestrator) {
        try {
            orchestrator.awaitCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw LOG.interruptedWhileWaitingForRequestCompletion(e);
        }
    }

    public void optimize() {
        this.performStreamOperation((LuceneWork)OptimizeLuceneWork.INSTANCE, null, false);
    }

    public String toString() {
        return "ElasticsearchIndexManager [actualIndexName=" + this.actualIndexName + "]";
    }

    public IndexManagerType getIndexManagerType() {
        return ElasticsearchIndexManagerType.INSTANCE;
    }
}

