/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;

public class bla {
    protected static final char[] pwd = "password".toCharArray();

    public static void main(String[] args) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream("/home/bela/certs/A.jks"), pwd);
        PrivateKey key = (PrivateKey)keyStore.getKey("a_key", pwd);
        Certificate[] certChain = keyStore.getCertificateChain("b_cert");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("tmp.txt"));
        out.writeInt(certChain.length);
        for (Certificate cert : certChain) {
            out.writeObject(cert);
        }
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream("tmp.txt"));
        int num = in.readInt();
        Certificate[] certs = new Certificate[num];
        for (int i = 0; i < certs.length; ++i) {
            certs[i] = (Certificate)in.readObject();
        }
        for (Certificate c : certs) {
            System.out.println("c = " + c);
        }
        for (Certificate cert : certs) {
            System.out.println("Cert Type : " + cert.getType());
            System.out.println("Cert Hash Code : " + cert.hashCode());
            System.out.println("Cert Public Key Algorithm : " + cert.getPublicKey().getAlgorithm());
            System.out.println("Cert Public Key Format : " + cert.getPublicKey().getFormat());
            System.out.println("\n");
            if (!(cert instanceof X509Certificate)) continue;
            try {
                ((X509Certificate)cert).checkValidity();
                System.out.println("Certificate is active for current date");
            }
            catch (CertificateExpiredException cee) {
                System.out.println("Certificate is expired");
            }
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ArrayList mylist = new ArrayList();
        Collections.addAll(mylist, certs);
        CertPath cp = cf.generateCertPath(mylist);
        PKIXParameters params = new PKIXParameters(keyStore);
        params.setRevocationEnabled(false);
        CertPathValidator cpv = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
        PKIXCertPathValidatorResult pkixCertPathValidatorResult = (PKIXCertPathValidatorResult)cpv.validate(cp, params);
        System.out.println("pkixCertPathValidatorResult = " + pkixCertPathValidatorResult);
    }
}

