/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

public class BeanManagerUtil {
    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    public static <T> T createBeanInstance(Class<T> clazz) {
        return BeanManagerUtil.createBeanInstance(clazz, BeanManagerUtil.getBeanManager());
    }

    public static <T> T createBeanInstance(Class<T> clazz, BeanManager bm) {
        Iterator iter = bm.getBeans(clazz, new Annotation[0]).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        Bean bean = (Bean)iter.next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        return (T)bm.getReference(bean, clazz, ctx);
    }
}

