/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentStatusHandler;

public abstract class DeploymentResourceDefinition
extends SimpleResourceDefinition {
    private DeploymentResourceParent parent;

    protected DeploymentResourceDefinition(DeploymentResourceParent parent, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"deployment"), DeploymentAttributes.DEPLOYMENT_RESOLVER).setAddHandler(addHandler).setRemoveHandler(removeHandler).setAccessConstraints(new AccessConstraintDefinition[]{ApplicationTypeAccessConstraintDefinition.DEPLOYMENT}));
        this.parent = parent;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : this.parent.getResourceAttributes()) {
            if (attr.getName().equals(DeploymentAttributes.STATUS.getName())) {
                resourceRegistration.registerMetric(attr, DeploymentStatusHandler.INSTANCE);
                continue;
            }
            if (attr.getName().equals(DeploymentAttributes.NAME.getName())) {
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DeploymentAttributes.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
                continue;
            }
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
    }

    public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
        for (NotificationDefinition notif : this.parent.getNotifications()) {
            resourceRegistration.registerNotification(notif);
        }
    }

    protected DeploymentResourceParent getParent() {
        return this.parent;
    }

    protected abstract void registerAddOperation(ManagementResourceRegistration var1, OperationStepHandler var2, OperationEntry.Flag ... var3);

    public static enum DeploymentResourceParent {
        DOMAIN(DeploymentAttributes.DOMAIN_RESOURCE_ATTRIBUTES, DeploymentAttributes.DOMAIN_ADD_ATTRIBUTES, new NotificationDefinition[0]),
        SERVER_GROUP(DeploymentAttributes.SERVER_GROUP_RESOURCE_ATTRIBUTES, DeploymentAttributes.SERVER_GROUP_ADD_ATTRIBUTES, new NotificationDefinition[0]),
        SERVER(DeploymentAttributes.SERVER_RESOURCE_ATTRIBUTES, DeploymentAttributes.SERVER_ADD_ATTRIBUTES, DeploymentAttributes.NOTIFICATION_DEPLOYMENT_DEPLOYED, DeploymentAttributes.NOTIFICATION_DEPLOYMENT_UNDEPLOYED);

        final AttributeDefinition[] resourceAttributes;
        final AttributeDefinition[] addAttributes;
        final NotificationDefinition[] notifications;

        private DeploymentResourceParent(AttributeDefinition[] resourceAttributes, AttributeDefinition[] addAttributes, NotificationDefinition ... notifications) {
            this.resourceAttributes = resourceAttributes;
            this.addAttributes = addAttributes;
            this.notifications = notifications == null ? new NotificationDefinition[]{} : notifications;
        }

        AttributeDefinition[] getResourceAttributes() {
            return this.resourceAttributes;
        }

        AttributeDefinition[] getAddAttributes() {
            return this.addAttributes;
        }

        NotificationDefinition[] getNotifications() {
            return this.notifications;
        }
    }
}

