/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.Arrays;
import java.util.Set;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;

public final class IckleParsingResult<TypeMetadata> {
    private final String queryString;
    private final Set<String> parameterNames;
    private final BooleanExpr whereClause;
    private final BooleanExpr havingClause;
    private final String targetEntityName;
    private final TypeMetadata targetEntityMetadata;
    private final PropertyPath[] projectedPaths;
    private final Class<?>[] projectedTypes;
    private final Object[] projectedNullMarkers;
    private final PropertyPath[] groupBy;
    private final SortField[] sortFields;

    public IckleParsingResult(String queryString, Set<String> parameterNames, BooleanExpr whereClause, BooleanExpr havingClause, String targetEntityName, TypeMetadata targetEntityMetadata, PropertyPath[] projectedPaths, Class<?>[] projectedTypes, Object[] projectedNullMarkers, PropertyPath[] groupBy, SortField[] sortFields) {
        this.queryString = queryString;
        this.parameterNames = parameterNames;
        this.whereClause = whereClause;
        this.havingClause = havingClause;
        this.targetEntityName = targetEntityName;
        this.targetEntityMetadata = targetEntityMetadata;
        if (projectedPaths != null && (projectedTypes == null || projectedTypes.length != projectedPaths.length) || projectedPaths == null && projectedTypes != null) {
            throw new IllegalArgumentException("projectedPaths and projectedTypes sizes must match");
        }
        this.projectedPaths = projectedPaths;
        this.projectedTypes = projectedTypes;
        this.projectedNullMarkers = projectedNullMarkers;
        this.groupBy = groupBy;
        this.sortFields = sortFields;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public BooleanExpr getWhereClause() {
        return this.whereClause;
    }

    public BooleanExpr getHavingClause() {
        return this.havingClause;
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public TypeMetadata getTargetEntityMetadata() {
        return this.targetEntityMetadata;
    }

    public String[] getProjections() {
        if (this.projectedPaths == null) {
            return null;
        }
        String[] projections = new String[this.projectedPaths.length];
        for (int i = 0; i < this.projectedPaths.length; ++i) {
            projections[i] = this.projectedPaths[i].asStringPath();
        }
        return projections;
    }

    public PropertyPath[] getProjectedPaths() {
        return this.projectedPaths;
    }

    public Class<?>[] getProjectedTypes() {
        return this.projectedTypes;
    }

    public Object[] getProjectedNullMarkers() {
        return this.projectedNullMarkers;
    }

    public boolean hasGroupingOrAggregations() {
        if (this.groupBy != null || this.havingClause != null) {
            return true;
        }
        if (this.projectedPaths != null) {
            for (PropertyPath p : this.projectedPaths) {
                if (!(p instanceof AggregationPropertyPath)) continue;
                return true;
            }
        }
        if (this.sortFields != null) {
            for (SortField s : this.sortFields) {
                if (!(s.getPath() instanceof AggregationPropertyPath)) continue;
                return true;
            }
        }
        return false;
    }

    public PropertyPath[] getGroupBy() {
        return this.groupBy;
    }

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public String toString() {
        return "FilterParsingResult [ queryString=" + this.queryString + ", targetEntityName=" + this.targetEntityName + ", parameterNames=" + this.parameterNames + ", whereClause=" + this.whereClause + ", havingClause=" + this.havingClause + ", projectedPaths=" + Arrays.toString(this.projectedPaths) + ", projectedTypes=" + Arrays.toString(this.projectedTypes) + ", projectedNullMarkers=" + Arrays.toString(this.projectedNullMarkers) + ", groupBy=" + Arrays.toString(this.groupBy) + ", sortFields=" + Arrays.toString(this.sortFields) + "]";
    }

    static final class SortFieldImpl<TypeMetadata>
    implements SortField {
        public final PropertyPath<TypeDescriptor<TypeMetadata>> path;
        public final boolean isAscending;

        SortFieldImpl(PropertyPath<TypeDescriptor<TypeMetadata>> path, boolean isAscending) {
            this.path = path;
            this.isAscending = isAscending;
        }

        public PropertyPath<TypeDescriptor<TypeMetadata>> getPath() {
            return this.path;
        }

        @Override
        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return "SortField(" + this.path + ", " + (this.isAscending ? "ASC" : "DESC") + ')';
        }
    }
}

