/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.http;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import net.oauth.http.HttpMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpResponseMessage
extends HttpMessage {
    public static final String LOCATION = "Location";
    public static final String STATUS_CODE = "HTTP status";
    public static final int STATUS_OK = 200;
    public static final String EOL = "\r\n";

    protected HttpResponseMessage(String method, URL url) {
        super(method, url);
    }

    @Override
    public void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        into.put(STATUS_CODE, this.getStatusCode());
        String location = this.getHeader(LOCATION);
        if (location != null) {
            into.put(LOCATION, location);
        }
    }

    public abstract int getStatusCode() throws IOException;
}

