/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js.templates.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import io.undertow.js.templates.Template;
import io.undertow.js.templates.TemplateProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FreemarkerTemplateProvider
implements TemplateProvider {
    private volatile Configuration cfg;
    private final Map<String, String> templates = Collections.synchronizedMap(new HashMap());

    @Override
    public String name() {
        return "freemarker";
    }

    @Override
    public void init(Map<String, String> properties) {
        boolean debug = false;
        if (properties.containsKey("debug")) {
            debug = Boolean.parseBoolean(properties.get("debug"));
        }
        this.cfg = new Configuration(Configuration.VERSION_2_3_22);
        this.cfg.setDefaultEncoding(properties.containsKey("charset") ? properties.get("charset") : "UTF-8");
        this.cfg.setTemplateExceptionHandler(debug ? TemplateExceptionHandler.DEBUG_HANDLER : TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setTemplateLoader(new TemplateLoader(){

            public Object findTemplateSource(String name) throws IOException {
                if (!FreemarkerTemplateProvider.this.templates.containsKey(name)) {
                    return null;
                }
                return name;
            }

            public long getLastModified(Object templateSource) {
                return 0L;
            }

            public Reader getReader(Object templateSource, String encoding) throws IOException {
                return new StringReader((String)FreemarkerTemplateProvider.this.templates.get(templateSource));
            }

            public void closeTemplateSource(Object templateSource) throws IOException {
            }
        });
    }

    @Override
    public Template compile(String templateName, String templateContents) {
        this.templates.put(templateName, templateContents);
        try {
            final freemarker.template.Template temp = this.cfg.getTemplate(templateName);
            return new Template(){

                @Override
                public String apply(Object data) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    try {
                        temp.process(data, (Writer)new OutputStreamWriter(out));
                        return new String(out.toByteArray(), FreemarkerTemplateProvider.this.cfg.getDefaultEncoding());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

