/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class JstlBaseTLV
extends TagLibraryValidator {
    private static final String EXP_ATT_PARAM = "expressionAttributes";
    protected static final String VAR = "var";
    protected static final String SCOPE = "scope";
    protected static final String PAGE_SCOPE = "page";
    protected static final String REQUEST_SCOPE = "request";
    protected static final String SESSION_SCOPE = "session";
    protected static final String APPLICATION_SCOPE = "application";
    protected final String JSP = "http://java.sun.com/JSP/Page";
    private static final int TYPE_UNDEFINED = 0;
    protected static final int TYPE_CORE = 1;
    protected static final int TYPE_FMT = 2;
    protected static final int TYPE_SQL = 3;
    protected static final int TYPE_XML = 4;
    private int tlvType = 0;
    protected String uri;
    protected String prefix;
    protected Vector messageVector;
    protected Map config;
    protected boolean failed;
    protected String lastElementId;

    protected abstract DefaultHandler getHandler();

    public JstlBaseTLV() {
        this.init();
    }

    private void init() {
        this.messageVector = null;
        this.prefix = null;
        this.config = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ValidationMessage[] validate(int type, String prefix, String uri, PageData page) {
        try {
            this.tlvType = type;
            this.uri = uri;
            this.messageVector = new Vector();
            this.prefix = prefix;
            try {
                if (this.config == null) {
                    this.configure((String)this.getInitParameters().get(EXP_ATT_PARAM));
                }
            }
            catch (NoSuchElementException ex) {
                return JstlBaseTLV.vmFromString(Resources.getMessage("TLV_PARAMETER_ERROR", EXP_ATT_PARAM));
            }
            DefaultHandler h = this.getHandler();
            XMLReader xmlReader = XmlUtil.newXMLReader(null);
            xmlReader.setContentHandler(h);
            InputStream inputStream = page.getInputStream();
            try {
                xmlReader.parse(new InputSource(inputStream));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.messageVector.size() == 0) {
                return null;
            }
            return JstlBaseTLV.vmFromVector(this.messageVector);
        }
        catch (SAXException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
        catch (IOException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
        catch (ParserConfigurationException ex) {
            return JstlBaseTLV.vmFromString(ex.toString());
        }
    }

    @Deprecated
    protected String validateExpression(String elem, String att, String expr) {
        return null;
    }

    protected boolean isTag(String tagUri, String tagLn, String matchUri, String matchLn) {
        if (tagUri == null || tagUri.length() == 0 || tagLn == null || matchUri == null || matchLn == null) {
            return false;
        }
        if (tagUri.length() > matchUri.length()) {
            return tagUri.startsWith(matchUri) && tagLn.equals(matchLn);
        }
        return matchUri.startsWith(tagUri) && tagLn.equals(matchLn);
    }

    protected boolean isJspTag(String tagUri, String tagLn, String target) {
        return this.isTag(tagUri, tagLn, "http://java.sun.com/JSP/Page", target);
    }

    private boolean isTag(int type, String tagUri, String tagLn, String target) {
        return this.tlvType == type && this.isTag(tagUri, tagLn, this.uri, target);
    }

    protected boolean isCoreTag(String tagUri, String tagLn, String target) {
        return this.isTag(1, tagUri, tagLn, target);
    }

    protected boolean isFmtTag(String tagUri, String tagLn, String target) {
        return this.isTag(2, tagUri, tagLn, target);
    }

    protected boolean isSqlTag(String tagUri, String tagLn, String target) {
        return this.isTag(3, tagUri, tagLn, target);
    }

    protected boolean isXmlTag(String tagUri, String tagLn, String target) {
        return this.isTag(4, tagUri, tagLn, target);
    }

    protected boolean hasAttribute(Attributes a, String att) {
        return a.getValue(att) != null;
    }

    protected void fail(String message) {
        this.failed = true;
        this.messageVector.add(new ValidationMessage(this.lastElementId, message));
    }

    protected boolean isSpecified(TagData data, String attributeName) {
        return data.getAttribute(attributeName) != null;
    }

    protected boolean hasNoInvalidScope(Attributes a) {
        String scope = a.getValue(SCOPE);
        return scope == null || scope.equals(PAGE_SCOPE) || scope.equals(REQUEST_SCOPE) || scope.equals(SESSION_SCOPE) || scope.equals(APPLICATION_SCOPE);
    }

    protected boolean hasEmptyVar(Attributes a) {
        return "".equals(a.getValue(VAR));
    }

    protected boolean hasDanglingScope(Attributes a) {
        return a.getValue(SCOPE) != null && a.getValue(VAR) == null;
    }

    protected String getLocalPart(String qname) {
        int colon = qname.indexOf(":");
        if (colon == -1) {
            return qname;
        }
        return qname.substring(colon + 1);
    }

    private void configure(String info) {
        this.config = new HashMap();
        if (info == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(info);
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            StringTokenizer pairTokens = new StringTokenizer(pair, ":");
            String element = pairTokens.nextToken();
            String attribute = pairTokens.nextToken();
            Object atts = this.config.get(element);
            if (atts == null) {
                atts = new HashSet();
                this.config.put(element, atts);
            }
            ((Set)atts).add(attribute);
        }
    }

    static ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    static ValidationMessage[] vmFromVector(Vector v) {
        ValidationMessage[] vm = new ValidationMessage[v.size()];
        for (int i = 0; i < vm.length; ++i) {
            vm[i] = (ValidationMessage)v.get(i);
        }
        return vm;
    }
}

