/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.DeploymentResourceDefinition;
import org.jboss.as.server.deployment.DeploymentAddHandler;
import org.jboss.as.server.deployment.DeploymentDeployHandler;
import org.jboss.as.server.deployment.DeploymentRedeployHandler;
import org.jboss.as.server.deployment.DeploymentRemoveHandler;
import org.jboss.as.server.deployment.DeploymentUndeployHandler;
import org.jboss.as.server.services.security.AbstractVaultReader;

public class ServerDeploymentResourceDefinition
extends DeploymentResourceDefinition {
    private final AbstractVaultReader vaultReader;

    private ServerDeploymentResourceDefinition(AbstractVaultReader vaultReader, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(DeploymentResourceDefinition.DeploymentResourceParent.SERVER, addHandler, removeHandler);
        this.vaultReader = vaultReader;
    }

    public static ServerDeploymentResourceDefinition create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new ServerDeploymentResourceDefinition(vaultReader, (OperationStepHandler)DeploymentAddHandler.create(contentRepository, vaultReader), (OperationStepHandler)new DeploymentRemoveHandler(contentRepository, vaultReader));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(DeploymentAttributes.DEPLOY_DEFINITION, (OperationStepHandler)new DeploymentDeployHandler(this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.UNDEPLOY_DEFINITION, (OperationStepHandler)new DeploymentUndeployHandler(this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.REDEPLOY_DEFINITION, (OperationStepHandler)new DeploymentRedeployHandler(this.vaultReader));
    }

    @Override
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(DeploymentAttributes.SERVER_DEPLOYMENT_ADD_DEFINITION, handler);
    }
}

