/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "replace-deployment";
    private final ContentRepository contentRepository;
    private final AbstractVaultReader vaultReader;

    protected DeploymentReplaceHandler(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.vaultReader = vaultReader;
    }

    public static DeploymentReplaceHandler create(ContentRepository contentRepository, AbstractVaultReader vaultReader) {
        return new DeploymentReplaceHandler(contentRepository, vaultReader);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode deployNode;
        String runtimeName;
        String toReplace;
        for (AttributeDefinition def : DeploymentAttributes.REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateOperation(operation);
        }
        String name = DeploymentAttributes.REPLACE_DEPLOYMENT_ATTRIBUTES.get("name").resolveModelAttribute(context, operation).asString();
        if (name.equals(toReplace = DeploymentAttributes.REPLACE_DEPLOYMENT_ATTRIBUTES.get("to-replace").resolveModelAttribute(context, operation).asString())) {
            throw ServerLogger.ROOT_LOGGER.cannotReplaceDeployment(OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment");
        }
        PathElement deployPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (!root.hasChild(replacePath)) {
            throw ServerLogger.ROOT_LOGGER.noSuchDeployment(toReplace);
        }
        ModelNode replaceNode = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{replacePath})).getModel();
        String replacedName = DeploymentAttributes.REPLACE_DEPLOYMENT_ATTRIBUTES.get("runtime-name").resolveModelAttribute(context, replaceNode).asString();
        if (!root.hasChild(deployPath)) {
            if (!operation.hasDefined("content")) {
                throw ServerLogger.ROOT_LOGGER.noSuchDeployment(name);
            }
            ModelNode content = operation.require("content");
            ModelNode contentItemNode = content.require(0);
            if (contentItemNode.hasDefined("hash")) {
                byte[] hash = contentItemNode.require("hash").asBytes();
                this.addFromHash(ModelContentReference.fromDeploymentName(name, hash));
            }
            runtimeName = operation.hasDefined("runtime-name") ? DeploymentAttributes.REPLACE_DEPLOYMENT_ATTRIBUTES.get("runtime-name").resolveModelAttribute(context, operation).asString() : replacedName;
            Resource deployResource = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{deployPath}));
            deployNode = deployResource.getModel();
            deployNode.get("runtime-name").set(runtimeName);
            deployNode.get("persistent").set(true);
            deployNode.get("content").set(content);
        } else {
            deployNode = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{deployPath})).getModel();
            if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployNode).asBoolean()) {
                throw ServerLogger.ROOT_LOGGER.deploymentAlreadyStarted(toReplace);
            }
            runtimeName = deployNode.require("runtime-name").asString();
        }
        deployNode.get(DeploymentAttributes.ENABLED.getName()).set(true);
        replaceNode.get(DeploymentAttributes.ENABLED.getName()).set(false);
        DeploymentHandlerUtil.ContentItem[] contents = DeploymentHandlerUtils.getContents(deployNode.require("content"));
        DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedName, this.vaultReader, contents);
    }

    protected void addFromHash(ContentReference reference) throws OperationFailedException {
        if (!this.contentRepository.syncContent(reference)) {
            throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(reference.getHexHash());
        }
    }
}

