/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.stack.IpAddress;

class DefaultDNSResolver
implements DNSResolver {
    private static final Pattern SRV_REGEXP = Pattern.compile("\\d+ \\d+ \\d+ ([\\w+.-]+)\\.");
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    final String dnsContextFactory;
    final String dnsAddress;
    final DirContext dnsContext;

    @Deprecated
    DefaultDNSResolver(DirContext direcoryContextForTests) {
        this.dnsContext = direcoryContextForTests;
        this.dnsAddress = null;
        this.dnsContextFactory = null;
    }

    public DefaultDNSResolver(String dnsContextFactory, String dnsAddress) {
        this.dnsContextFactory = dnsContextFactory;
        this.dnsAddress = dnsAddress;
        this.dnsContext = this.getDnsContext();
    }

    private final DirContext getDnsContext() {
        try {
            log.trace("Initializing DNS Context with factory: %s and url: %s", this.dnsContextFactory, this.dnsAddress);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.dnsContextFactory);
            env.put("java.naming.provider.url", "dns://" + this.dnsAddress);
            return new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Wrong DNS Context", e);
        }
    }

    @Override
    public List<Address> resolveIps(String dnsQuery, DNSResolver.DNSRecordType recordType) {
        log.trace("Resolving DNS Query: %s of a type: %s", dnsQuery, recordType.toString());
        switch (recordType) {
            case A: {
                return this.resolveAEntries(dnsQuery);
            }
            case SRV: {
                return this.resolveSRVEntries(dnsQuery);
            }
        }
        throw new IllegalStateException("Not implemented");
    }

    private List<Address> resolveSRVEntries(String dnsQuery) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            Attributes attributes = this.dnsContext.getAttributes(dnsQuery, new String[]{DNSResolver.DNSRecordType.SRV.toString()});
            if (attributes != null && attributes.getAll().hasMoreElements()) {
                NamingEnumeration<?> namingEnumeration = attributes.get(DNSResolver.DNSRecordType.SRV.toString()).getAll();
                while (namingEnumeration.hasMoreElements()) {
                    try {
                        String srvEntry = namingEnumeration.nextElement().toString();
                        Matcher matcher = SRV_REGEXP.matcher(srvEntry);
                        if (!matcher.find()) continue;
                        String srcDNSRecord = matcher.group(1);
                        addresses.addAll(this.resolveAEntries(srcDNSRecord));
                    }
                    catch (Exception e) {
                        log.trace("Non critical DNS resolution error", e);
                    }
                }
            }
        }
        catch (NamingException e) {
            log.trace("No DNS records for query: " + dnsQuery);
        }
        return addresses;
    }

    private List<Address> resolveAEntries(String dnsQuery) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            Attributes attributes = this.dnsContext.getAttributes(dnsQuery, new String[]{DNSResolver.DNSRecordType.A.toString()});
            if (attributes != null && attributes.getAll().hasMoreElements()) {
                NamingEnumeration<?> namingEnumeration = attributes.get(DNSResolver.DNSRecordType.A.toString()).getAll();
                while (namingEnumeration.hasMoreElements()) {
                    try {
                        addresses.add(new IpAddress(namingEnumeration.nextElement().toString()));
                    }
                    catch (Exception e) {
                        log.trace("Non critical DNS resolution error", e);
                    }
                }
            }
        }
        catch (NamingException e) {
            log.trace("No DNS records for query: " + dnsQuery);
        }
        return addresses;
    }
}

