/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jgroups.util.Util;

public class bla5 {
    DelayQueue<DelayedInt> queue = new DelayQueue();

    public static void main(String[] args) throws Exception {
        new bla5().start();
    }

    private void start() throws InterruptedException {
        this.queue.add(new DelayedInt(1, System.currentTimeMillis() + 5000L));
        new Thread(() -> {
            Util.sleep(1000L);
            Stream.of(2, 3, 6, 7).forEach(n -> this.queue.add(new DelayedInt((int)n, n * 1000)));
        }).start();
        while (true) {
            DelayedInt el = (DelayedInt)this.queue.poll(10000L, TimeUnit.MILLISECONDS);
            System.out.println("el = " + el);
        }
    }

    protected static class DelayedInt
    implements Delayed {
        protected final int num;
        protected final long target_time;

        public DelayedInt(int num, long target_time) {
            this.num = num;
            this.target_time = target_time;
        }

        @Override
        public int compareTo(Delayed o) {
            long other_delay;
            DelayedInt other = (DelayedInt)o;
            long my_delay = this.getDelay(TimeUnit.MILLISECONDS);
            return my_delay < (other_delay = other.getDelay(TimeUnit.MILLISECONDS)) ? -1 : (my_delay > other_delay ? 1 : 0);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.target_time - System.currentTimeMillis();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        public String toString() {
            return String.valueOf(this.num);
        }
    }
}

