/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.AuthenticationConfiguration;
import org.infinispan.persistence.remote.configuration.ConnectionPoolConfiguration;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.ExecutorFactoryConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteServerConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.SecurityConfiguration;
import org.infinispan.persistence.remote.configuration.SslConfiguration;

public class RemoteStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RemoteStoreConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, RemoteStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.REMOTE_STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeAsyncExecutor(writer, configuration.asyncExecutorFactory());
        this.writeConnectionPool(writer, configuration.connectionPool());
        this.writeServers(writer, configuration.servers());
        this.writeSecurity(writer, configuration.security());
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }

    private void writeAsyncExecutor(XMLExtendedStreamWriter writer, ExecutorFactoryConfiguration executorFactoryConfiguration) throws XMLStreamException {
        AttributeSet attributes = executorFactoryConfiguration.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.ASYNC_TRANSPORT_EXECUTOR);
            attributes.write((XMLStreamWriter)writer, ExecutorFactoryConfiguration.EXECUTOR_FACTORY, (Enum)Attribute.FACTORY);
            SerializeUtils.writeTypedProperties((XMLExtendedStreamWriter)writer, (TypedProperties)executorFactoryConfiguration.properties());
            writer.writeEndElement();
        }
    }

    private void writeConnectionPool(XMLExtendedStreamWriter writer, ConnectionPoolConfiguration connectionPool) throws XMLStreamException {
        writer.writeStartElement((Enum)Element.CONNECTION_POOL);
        writer.writeAttribute((Enum)Attribute.EXHAUSTED_ACTION, connectionPool.exhaustedAction().name());
        writer.writeAttribute((Enum)Attribute.MAX_ACTIVE, Integer.toString(connectionPool.maxActive()));
        writer.writeAttribute((Enum)Attribute.MAX_IDLE, Integer.toString(connectionPool.maxIdle()));
        writer.writeAttribute((Enum)Attribute.MIN_IDLE, Integer.toString(connectionPool.minIdle()));
        writer.writeAttribute((Enum)Attribute.MAX_TOTAL, Integer.toString(connectionPool.maxTotal()));
        writer.writeAttribute((Enum)Attribute.MIN_EVICTABLE_IDLE_TIME, Long.toString(connectionPool.minEvictableIdleTime()));
        writer.writeAttribute((Enum)Attribute.TIME_BETWEEN_EVICTION_RUNS, Long.toString(connectionPool.timeBetweenEvictionRuns()));
        writer.writeAttribute((Enum)Attribute.TEST_WHILE_IDLE, Boolean.toString(connectionPool.testWhileIdle()));
        writer.writeEndElement();
    }

    private void writeServers(XMLExtendedStreamWriter writer, List<RemoteServerConfiguration> servers) throws XMLStreamException {
        for (RemoteServerConfiguration server : servers) {
            writer.writeStartElement((Enum)Element.SERVER);
            writer.writeAttribute((Enum)Attribute.HOST, server.host());
            writer.writeAttribute((Enum)Attribute.PORT, Integer.toString(server.port()));
            writer.writeEndElement();
        }
    }

    private void writeSecurity(XMLExtendedStreamWriter writer, SecurityConfiguration security) throws XMLStreamException {
        if (security.authentication().attributes().isModified() || security.ssl().attributes().isModified()) {
            writer.writeStartElement((Enum)Element.SECURITY);
            this.writeAuthentication(writer, security.authentication());
            this.writeEncryption(writer, security.ssl());
            writer.writeEndElement();
        }
    }

    private void writeAuthentication(XMLExtendedStreamWriter writer, AuthenticationConfiguration authentication) throws XMLStreamException {
        AttributeSet attributeSet = authentication.attributes();
        if (attributeSet.isModified()) {
            writer.writeStartElement((Enum)Element.AUTHENTICATION);
            attributeSet.write((XMLStreamWriter)writer);
            switch (authentication.saslMechanism()) {
                case "PLAIN": {
                    writer.writeStartElement((Enum)Element.AUTH_PLAIN);
                    writer.writeAttribute((Enum)Attribute.USERNAME, authentication.username());
                    writer.writeAttribute((Enum)Attribute.PASSWORD, new String(authentication.password()));
                    writer.writeEndElement();
                    break;
                }
                case "DIGEST-MD5": {
                    writer.writeStartElement((Enum)Element.AUTH_DIGEST);
                    writer.writeAttribute((Enum)Attribute.USERNAME, authentication.username());
                    writer.writeAttribute((Enum)Attribute.PASSWORD, new String(authentication.password()));
                    writer.writeAttribute((Enum)Attribute.REALM, authentication.realm());
                    writer.writeEndElement();
                    break;
                }
                case "EXTERNAL": {
                    writer.writeEmptyElement((Enum)Element.AUTH_EXTERNAL);
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeEncryption(XMLExtendedStreamWriter writer, SslConfiguration ssl) throws XMLStreamException {
        AttributeSet attributes = ssl.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement((Enum)Element.ENCRYPTION);
            attributes.write((XMLStreamWriter)writer);
            if (ssl.keyStoreFileName() != null) {
                writer.writeStartElement((Enum)Element.KEYSTORE);
                writer.writeAttribute((Enum)Attribute.FILENAME, ssl.keyStoreFileName());
                writer.writeAttribute((Enum)Attribute.PASSWORD, new String(ssl.keyStorePassword()));
                writer.writeAttribute((Enum)Attribute.CERTIFICATE_PASSWORD, new String(ssl.keyStoreCertificatePassword()));
                writer.writeAttribute((Enum)Attribute.KEY_ALIAS, ssl.keyAlias());
                writer.writeAttribute((Enum)Attribute.TYPE, ssl.keyStoreType());
                writer.writeEndElement();
            }
            if (ssl.trustStoreFileName() != null) {
                writer.writeStartElement((Enum)Element.TRUSTSTORE);
                writer.writeAttribute((Enum)Attribute.FILENAME, ssl.trustStoreFileName());
                writer.writeAttribute((Enum)Attribute.PASSWORD, new String(ssl.trustStorePassword()));
                writer.writeAttribute((Enum)Attribute.TYPE, ssl.trustStoreType());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

