/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClearCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.NotifyHelper;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.TimeService;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public LocalizedCacheTopology getCacheTopology();

    @Deprecated
    default public boolean localNodeIsOwner(Object key) {
        return this.getCacheTopology().isWriteOwner(key);
    }

    @Deprecated
    default public boolean localNodeIsPrimaryOwner(Object key) {
        return this.getCacheTopology().getDistribution(key).isPrimary();
    }

    @Deprecated
    default public Address getPrimaryOwner(Object key) {
        return this.getCacheTopology().getDistribution(key).primary();
    }

    public void commitEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

    public Commit commitType(FlagAffectedCommand var1, InvocationContext var2, Object var3, boolean var4);

    @Deprecated
    default public Collection<Address> getOwners(Collection<Object> keys) {
        return this.getCacheTopology().getWriteOwners(keys);
    }

    @Deprecated
    default public Collection<Address> getOwners(Object key) {
        return this.getCacheTopology().getWriteOwners(key);
    }

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static class ScatteredLogic
    extends DistributionLogic {
        @Override
        protected void commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        private Configuration configuration;
        private StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsOwner = key -> this.getCacheTopology().isWriteOwner(key);
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = key -> this.getCacheTopology().getDistribution(key).isPrimary();

        @Inject
        public void init(Configuration configuration, StateTransferLock stateTransferLock) {
            this.configuration = configuration;
            this.stateTransferLock = stateTransferLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                Commit doCommit = this.commitType(command, ctx, entry.getKey(), entry.isRemoved());
                boolean isL1Write = false;
                if (!doCommit.isCommit() && this.configuration.clustering().l1().enabled()) {
                    long lifespan;
                    if (!(entry.isRemoved() || (lifespan = entry.getLifespan()) >= 0L && lifespan <= this.configuration.clustering().l1().lifespan())) {
                        Metadata metadata = entry.getMetadata().builder().lifespan(this.configuration.clustering().l1().lifespan()).build();
                        entry.setMetadata(new L1Metadata(metadata));
                    }
                    isL1Write = true;
                    doCommit = Commit.COMMIT_NON_LOCAL;
                } else if (doCommit.isCommit() && entry.getMetadata() instanceof L1Metadata) {
                    throw new IllegalStateException("Local entries must not have L1 metadata");
                }
                if (doCommit.isCommit()) {
                    boolean created = false;
                    boolean removed = false;
                    boolean expired = false;
                    if (doCommit.isLocal()) {
                        created = entry.isCreated();
                        removed = entry.isRemoved();
                        if (removed && entry instanceof MVCCEntry) {
                            expired = ((MVCCEntry)entry).isExpired();
                        }
                    }
                    InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
                    Object previousValue = null;
                    Metadata previousMetadata = null;
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    if (isL1Write && previousEntry != null && !previousEntry.isL1Entry()) {
                    } else {
                        this.commitManager.commit(entry, trackFlag, l1Invalidation || isL1Write, ctx);
                        if (doCommit.isLocal()) {
                            NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
                        }
                    }
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? this.localNodeIsOwner : this.localNodeIsPrimaryOwner;
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        private StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = key -> this.getCacheTopology().getDistribution(key).isPrimary();

        @Inject
        public void init(StateTransferLock stateTransferLock) {
            this.stateTransferLock = stateTransferLock;
        }

        @Override
        public Collection<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            if (keys.isEmpty()) {
                return Collections.emptyList();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                Commit doCommit = this.commitType(command, ctx, entry.getKey(), entry.isRemoved());
                if (doCommit.isCommit()) {
                    boolean created = false;
                    boolean removed = false;
                    boolean expired = false;
                    if (doCommit.isLocal()) {
                        created = entry.isCreated();
                        removed = entry.isRemoved();
                        if (removed && entry instanceof MVCCEntry) {
                            expired = ((MVCCEntry)entry).isExpired();
                        }
                    }
                    InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
                    Object previousValue = null;
                    Metadata previousMetadata = null;
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    this.commitManager.commit(entry, trackFlag, l1Invalidation, ctx);
                    if (doCommit.isLocal()) {
                        NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
                    }
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? key -> true : this.localNodeIsPrimaryOwner;
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        @Override
        protected void commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
            Object previousValue = null;
            Metadata previousMetadata = null;
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            }
            this.commitManager.commit(entry, trackFlag, l1Invalidation, ctx);
            NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        private LocalizedCacheTopology localTopology;

        @Inject
        public void init(Transport transport) {
            Address address = transport != null ? transport.getAddress() : LocalModeAddress.INSTANCE;
            this.localTopology = LocalizedCacheTopology.makeSingletonTopology(CacheMode.LOCAL, address);
        }

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.localTopology;
        }

        @Override
        public Address getAddress() {
            return this.localTopology.getLocalAddress();
        }

        @Override
        protected void commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            InternalCacheEntry previousEntry = this.dataContainer.peek(entry.getKey());
            Object previousValue = null;
            Metadata previousMetadata = null;
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            }
            this.commitManager.commit(entry, trackFlag, l1Invalidation, ctx);
            NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata);
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return key -> true;
        }
    }

    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        protected DistributionManager distributionManager;
        protected DataContainer<Object, Object> dataContainer;
        protected CacheNotifier<Object, Object> notifier;
        protected boolean totalOrder;
        private WriteSkewHelper.KeySpecificLogic keySpecificLogic;
        protected CommitManager commitManager;
        protected PersistenceManager persistenceManager;
        protected TimeService timeService;
        protected FunctionalNotifier<Object, Object> functionalNotifier;

        @Inject
        public void init(DataContainer<Object, Object> dataContainer, CacheNotifier<Object, Object> notifier, Configuration configuration, CommitManager commitManager, PersistenceManager persistenceManager, TimeService timeService, FunctionalNotifier<Object, Object> functionalNotifier, DistributionManager distributionManager) {
            this.dataContainer = dataContainer;
            this.notifier = notifier;
            this.totalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
            this.distributionManager = distributionManager;
            this.keySpecificLogic = this.initKeySpecificLogic(this.totalOrder);
            this.commitManager = commitManager;
            this.persistenceManager = persistenceManager;
            this.timeService = timeService;
            this.functionalNotifier = functionalNotifier;
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            return this.totalOrder ? this.totalOrderCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand) : this.clusteredCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand);
        }

        @Override
        public final void commitEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            if (entry instanceof ClearCacheEntry) {
                this.commitClearCommand(this.dataContainer, (ClearCacheEntry)entry, ctx, command);
            } else {
                this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation);
            }
        }

        private void commitClearCommand(DataContainer<Object, Object> dataContainer, ClearCacheEntry<Object, Object> cacheEntry, InvocationContext context, FlagAffectedCommand command) {
            ArrayList copyEntries = new ArrayList(dataContainer.sizeIncludingExpired());
            dataContainer.iterator().forEachRemaining(copyEntries::add);
            cacheEntry.commit(dataContainer);
            for (InternalCacheEntry entry : copyEntries) {
                this.notifier.notifyCacheEntryRemoved(entry.getKey(), entry.getValue(), entry.getMetadata(), false, context, command);
            }
        }

        protected abstract void commitSingleEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, Object key, boolean removed) {
            boolean transactional;
            if (command != null && command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
                return Commit.COMMIT_LOCAL;
            }
            boolean bl = transactional = ctx.isInTxScope() && (command == null || !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ));
            if (transactional || !ctx.isOriginLocal() || command != null && (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL) || command instanceof ClearCommand)) {
                if (this.getCacheTopology().isWriteOwner(key)) {
                    return Commit.COMMIT_LOCAL;
                }
                if (removed) {
                    return Commit.COMMIT_NON_LOCAL;
                }
            } else {
                return this.getCacheTopology().getDistribution(key).isPrimary() ? Commit.COMMIT_LOCAL : Commit.NO_COMMIT;
            }
            return Commit.NO_COMMIT;
        }

        protected abstract WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean var1);

        private EntryVersionsMap totalOrderCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (context.isOriginLocal()) {
                throw new IllegalStateException("This must not be reached");
            }
            EntryVersionsMap updatedVersionMap = new EntryVersionsMap();
            if (!((TotalOrderPrepareCommand)((Object)prepareCommand)).skipWriteSkewCheck()) {
                updatedVersionMap = WriteSkewHelper.performTotalOrderWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, this.persistenceManager, versionGenerator, context, this.keySpecificLogic, this.timeService);
            }
            for (WriteCommand c : prepareCommand.getModifications()) {
                for (Object k : c.getAffectedKeys()) {
                    if (!this.keySpecificLogic.performCheckOnKey(k) || updatedVersionMap.containsKey(k)) continue;
                    updatedVersionMap.put(k, null);
                }
            }
            ((AbstractCacheTransaction)context.getCacheTransaction()).setUpdatedEntryVersions(updatedVersionMap);
            return updatedVersionMap;
        }

        private EntryVersionsMap clusteredCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.dataContainer, this.persistenceManager, versionGenerator, context, this.keySpecificLogic, this.timeService);
            Object cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.distributionManager.getCacheTopology();
        }

        @Override
        public Address getAddress() {
            return this.getCacheTopology().getLocalAddress();
        }
    }

    public static enum Commit {
        NO_COMMIT(false, false),
        COMMIT_NON_LOCAL(true, false),
        COMMIT_LOCAL(true, true);

        private boolean commit;
        private boolean local;

        private Commit(boolean commit, boolean local) {
            this.commit = commit;
            this.local = local;
        }

        public boolean isCommit() {
            return this.commit;
        }

        public boolean isLocal() {
            return this.local;
        }
    }
}

