/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.gssapi;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.sasl.gssapi.SubjectIdentity;

public class GssapiServer
implements SaslServer {
    private SubjectIdentity identity;
    private final SaslServer wrapped;

    GssapiServer(SubjectIdentity identity, SaslServer toWrap) {
        this.identity = identity;
        this.wrapped = toWrap;
    }

    @Override
    public String getMechanismName() {
        return this.wrapped.getMechanismName();
    }

    @Override
    public byte[] evaluateResponse(final byte[] response) throws SaslException {
        Subject subject = this.identity.getSubject();
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return GssapiServer.this.wrapped.evaluateResponse(response);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SaslException)e.getException();
        }
    }

    @Override
    public boolean isComplete() {
        return this.wrapped.isComplete();
    }

    @Override
    public String getAuthorizationID() {
        return this.wrapped.getAuthorizationID();
    }

    @Override
    public byte[] unwrap(final byte[] incoming, final int offset, final int len) throws SaslException {
        Subject subject = this.identity.getSubject();
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return GssapiServer.this.wrapped.unwrap(incoming, offset, len);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SaslException)e.getException();
        }
    }

    @Override
    public byte[] wrap(final byte[] outgoing, final int offset, final int len) throws SaslException {
        Subject subject = this.identity.getSubject();
        try {
            return Subject.doAs(subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return GssapiServer.this.wrapped.wrap(outgoing, offset, len);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SaslException)e.getException();
        }
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return this.wrapped.getNegotiatedProperty(propName);
    }

    @Override
    public void dispose() throws SaslException {
        Subject subject = this.getSubject();
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws SaslException {
                    GssapiServer.this.wrapped.dispose();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (SaslException)e.getException();
        }
        this.identity.dispose();
        this.identity = null;
    }

    private Subject getSubject() throws SaslException {
        if (this.identity != null) {
            return this.identity.getSubject();
        }
        throw new SaslException("dispose() has already been called on this SaslServer.");
    }
}

