/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations.mediatypes;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.rest.operations.mediatypes.OutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.BinaryOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.HTMLOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.JSONOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.TextOutputPrinter;
import org.infinispan.rest.operations.mediatypes.impl.XMLOutputPrinter;

public enum MediaType {
    TEXT_PLAIN("text/plain", new TextOutputPrinter(), true),
    TEXT_HTML("text/html", new HTMLOutputPrinter(), true),
    APPLICATION_TEXT("application/text", new TextOutputPrinter(), true),
    APPLICATION_XML("application/xml", new XMLOutputPrinter(), true),
    APPLICATION_JSON("application/json", new JSONOutputPrinter(), true),
    APPLICATION_OCTET_STREAM("application/octet-stream", new BinaryOutputPrinter(), false),
    IMAGE_PNG("image/png", new BinaryOutputPrinter(), false),
    APPLICATION_BINARY("application/binary", new BinaryOutputPrinter(), false),
    APPLICATION_SERIALIZED_OBJECT("application/x-java-serialized-object", new BinaryOutputPrinter(), false);

    private static final Map<String, MediaType> reverseLookup;
    private final String mediaTypeAsString;
    private final OutputPrinter outputPrinter;
    private final boolean needsCharset;

    private MediaType(String mediaTypeAsString, OutputPrinter outputPrinter, boolean needsCharset) {
        this.mediaTypeAsString = mediaTypeAsString;
        this.outputPrinter = outputPrinter;
        this.needsCharset = needsCharset;
    }

    public static MediaType fromMediaTypeAsString(String text) {
        String[] suppliedMediaTypes = text.split(" *, *");
        for (int i = 0; i < suppliedMediaTypes.length; ++i) {
            MediaType decodedMediaType = reverseLookup.get(MediaType.sanitize(suppliedMediaTypes[i]));
            if (decodedMediaType == null) continue;
            return decodedMediaType;
        }
        return null;
    }

    private static String sanitize(String text) {
        int charsetSeparator = text.indexOf(59);
        if (charsetSeparator != -1) {
            text = text.substring(0, text.indexOf(";"));
        }
        return text;
    }

    public OutputPrinter getOutputPrinter() {
        return this.outputPrinter;
    }

    public String toString() {
        return this.mediaTypeAsString;
    }

    public boolean needsCharset() {
        return this.needsCharset;
    }

    static {
        reverseLookup = new HashMap<String, MediaType>(MediaType.values().length);
        for (MediaType type : MediaType.values()) {
            reverseLookup.put(type.mediaTypeAsString, type);
        }
    }
}

