/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.RoaringDocIdSet;

@Deprecated
public class CachingWrapperQuery
extends Query
implements Accountable,
Cloneable {
    private Query query;
    private final QueryCachingPolicy policy;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());
    int hitCount;
    int missCount;

    public CachingWrapperQuery(Query query, QueryCachingPolicy policy) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
        this.policy = Objects.requireNonNull(policy, "QueryCachingPolicy must not be null");
    }

    public CachingWrapperQuery(Query query) {
        this(query, QueryCachingPolicy.CacheOnLargeSegments.DEFAULT);
    }

    public Query getQuery() {
        return this.query;
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader) throws IOException {
        return new RoaringDocIdSet.Builder(reader.maxDoc()).add(iterator).build();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query rewritten = this.query.rewrite(reader);
        if (this.query == rewritten) {
            return super.rewrite(reader);
        }
        CachingWrapperQuery clone = (CachingWrapperQuery)this.clone();
        clone.query = rewritten;
        return clone;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        if (needsScores) {
            return weight;
        }
        return new ConstantScoreWeight(weight.getQuery()){
            final AtomicBoolean used;
            {
                super(x0);
                this.used = new AtomicBoolean(false);
            }

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (this.used.compareAndSet(false, true)) {
                    CachingWrapperQuery.this.policy.onUse(this.getQuery());
                }
                LeafReader reader = context.reader();
                Object key = reader.getCoreCacheKey();
                DocIdSet docIdSet = (DocIdSet)CachingWrapperQuery.this.cache.get(key);
                if (docIdSet != null) {
                    ++CachingWrapperQuery.this.hitCount;
                } else if (CachingWrapperQuery.this.policy.shouldCache(CachingWrapperQuery.this.query, context)) {
                    ++CachingWrapperQuery.this.missCount;
                    Scorer scorer = weight.scorer(context);
                    docIdSet = scorer == null ? DocIdSet.EMPTY : CachingWrapperQuery.this.cacheImpl(scorer.iterator(), context.reader());
                    CachingWrapperQuery.this.cache.put(key, docIdSet);
                } else {
                    return weight.scorer(context);
                }
                assert (docIdSet != null);
                if (docIdSet == DocIdSet.EMPTY) {
                    return null;
                }
                DocIdSetIterator disi = docIdSet.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, disi);
            }
        };
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(" + this.query.toString(field) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        CachingWrapperQuery other = (CachingWrapperQuery)o;
        return this.query.equals(other.query);
    }

    @Override
    public int hashCode() {
        return this.query.hashCode() ^ super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ramBytesUsed() {
        ArrayList<DocIdSet> docIdSets;
        Map<Object, DocIdSet> map = this.cache;
        synchronized (map) {
            docIdSets = new ArrayList<DocIdSet>(this.cache.values());
        }
        long total = 0L;
        for (DocIdSet dis : docIdSets) {
            total += dis.ramBytesUsed();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        Map<Object, DocIdSet> map = this.cache;
        synchronized (map) {
            return Accountables.namedAccountables("segment", this.cache);
        }
    }
}

