/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.wildfly.clustering.ee.infinispan.Remover;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.SessionExpirationListener;

public class ExpiredSessionRemover<MV, AV, L>
implements Remover<String> {
    private final SessionFactory<MV, AV, L> factory;
    private final SessionExpirationListener listener;

    public ExpiredSessionRemover(SessionFactory<MV, AV, L> factory, SessionExpirationListener listener) {
        this.factory = factory;
        this.listener = listener;
    }

    public boolean remove(String id) {
        ImmutableSession session;
        Map.Entry value = (Map.Entry)this.factory.tryValue(id);
        if (value != null && (session = this.factory.createImmutableSession(id, value)).getMetaData().isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s has expired.", id);
            this.listener.sessionExpired(this.factory.createImmutableSession(id, value));
            return this.factory.remove(id);
        }
        return false;
    }
}

