/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.Collections;
import java.util.List;
import org.infinispan.server.commons.controller.ReloadRequiredAddStepHandler;
import org.infinispan.server.jgroups.subsystem.Attribute;
import org.infinispan.server.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum ThreadPoolResourceDefinition implements ResourceDefinition
{
    DEFAULT("default", 0, 200, 0, 60000L),
    OOB("oob", 20, 200, 0, 60000L),
    INTERNAL("internal", 5, 20, 500, 60000L),
    TIMER("timer", 2, 4, 500, 5000L);

    static final PathElement WILDCARD_PATH;
    private final String name;
    private final ResourceDescriptionResolver descriptionResolver;
    private final SimpleAttributeDefinition minThreads;
    private final SimpleAttributeDefinition maxThreads;
    private final SimpleAttributeDefinition queueLength;
    private final SimpleAttributeDefinition keepaliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime) {
        this.name = name;
        this.descriptionResolver = new JGroupsResourceDescriptionResolver("transport", "thread-pool");
        this.minThreads = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(Attribute.MIN_THREADS.getLocalName(), ModelType.INT, true).setDefaultValue(new ModelNode(defaultMinThreads))).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
        this.maxThreads = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(Attribute.MAX_THREADS.getLocalName(), ModelType.INT, true).setDefaultValue(new ModelNode(defaultMaxThreads))).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
        this.queueLength = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(Attribute.QUEUE_LENGTH.getLocalName(), ModelType.INT, true).setDefaultValue(new ModelNode(defaultQueueLength))).setValidator((ParameterValidator)new IntRangeValidator(0, Integer.MAX_VALUE, false, true))).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
        this.keepaliveTime = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(Attribute.KEEPALIVE_TIME.getLocalName(), ModelType.LONG, true).setDefaultValue(new ModelNode(defaultKeepaliveTime))).setValidator((ParameterValidator)new LongRangeValidator(0L, Long.MAX_VALUE, false, true))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();
    }

    public PathElement getPathElement() {
        return ThreadPoolResourceDefinition.pathElement(this.name);
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration registration) {
        return new DefaultResourceDescriptionProvider(registration, this.descriptionResolver);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        SimpleOperationDefinition addOperation = new SimpleOperationDefinitionBuilder("add", this.descriptionResolver).setParameters(this.getAttributes()).build();
        registration.registerOperationHandler((OperationDefinition)addOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(this.getAttributes()));
        registration.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder("remove", this.descriptionResolver).build(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attribute : this.getAttributes()) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerNotifications(ManagementResourceRegistration registration) {
    }

    public void registerChildren(ManagementResourceRegistration registration) {
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isOrderedChild() {
        return false;
    }

    AttributeDefinition[] getAttributes() {
        return new AttributeDefinition[]{this.minThreads, this.maxThreads, this.queueLength, this.keepaliveTime};
    }

    SimpleAttributeDefinition getMinThreads() {
        return this.minThreads;
    }

    SimpleAttributeDefinition getMaxThreads() {
        return this.maxThreads;
    }

    SimpleAttributeDefinition getQueueLength() {
        return this.queueLength;
    }

    SimpleAttributeDefinition getKeepaliveTime() {
        return this.keepaliveTime;
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

