/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    JCA_1_1("urn:jboss:domain:jca:1.1"),
    JCA_2_0("urn:jboss:domain:jca:2.0"),
    JCA_3_0("urn:jboss:domain:jca:3.0"),
    JCA_4_0("urn:jboss:domain:jca:4.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = JCA_4_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

