/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.functional.Param;

@Experimental
public final class Params {
    private static final Param<?>[] DEFAULTS = new Param[]{Param.PersistenceMode.defaultValue(), Param.LockingMode.defaultValue(), Param.ExecutionMode.defaultValue()};
    private static final Params DEFAULT_INSTANCE = new Params(DEFAULTS);
    final Param<?>[] params;

    private Params(Param<?>[] params) {
        this.params = params;
    }

    public boolean containsAll(Param<?> ... ps) {
        List<Param<?>> paramsToCheck = Arrays.asList(ps);
        List<Param<Param<?>>> paramsCurrent = Arrays.asList(this.params);
        return paramsCurrent.containsAll(paramsToCheck);
    }

    public Params addAll(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        Param[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        paramsToAdd.forEach(p -> {
            paramsAll[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    public Params addAll(Params ps) {
        if (ps == DEFAULT_INSTANCE) {
            return this;
        }
        Param<?>[] paramsAll = Arrays.copyOf(this.params, this.params.length);
        for (int i = 0; i < this.params.length; ++i) {
            if (ps.params[i].equals(DEFAULTS[i])) continue;
            paramsAll[i] = ps.params[i];
        }
        return new Params(paramsAll);
    }

    public <T> Param<T> get(int index) {
        return this.params[index];
    }

    public String toString() {
        return "Params=" + Arrays.toString(this.params);
    }

    public long toFlagsBitSet() {
        Param.PersistenceMode persistenceMode = (Param.PersistenceMode)this.params[0].get();
        Param.LockingMode lockingMode = (Param.LockingMode)this.params[1].get();
        Param.ExecutionMode executionMode = (Param.ExecutionMode)this.params[2].get();
        long flagsBitSet = 0L;
        if (persistenceMode == Param.PersistenceMode.SKIP) {
            flagsBitSet |= FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_CACHE_STORE;
        }
        if (lockingMode == Param.LockingMode.SKIP) {
            flagsBitSet |= FlagBitSets.SKIP_LOCKING;
        }
        if (executionMode == Param.ExecutionMode.LOCAL) {
            flagsBitSet |= FlagBitSets.CACHE_MODE_LOCAL;
        } else if (executionMode == Param.ExecutionMode.LOCAL_SITE) {
            flagsBitSet |= FlagBitSets.SKIP_XSITE_BACKUP;
        }
        return flagsBitSet;
    }

    public static Params fromFlagsBitSet(long flagsBitSet) {
        Params params = Params.create();
        if ((flagsBitSet & (FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_CACHE_STORE)) != 0L) {
            params = params.addAll(Param.PersistenceMode.SKIP);
        }
        if ((flagsBitSet & FlagBitSets.SKIP_LOCKING) != 0L) {
            params = params.addAll(Param.LockingMode.SKIP);
        }
        if ((flagsBitSet & FlagBitSets.CACHE_MODE_LOCAL) != 0L) {
            params = params.addAll(Param.ExecutionMode.LOCAL);
        } else if ((flagsBitSet & FlagBitSets.SKIP_XSITE_BACKUP) != 0L) {
            params = params.addAll(Param.ExecutionMode.LOCAL_SITE);
        }
        return params;
    }

    public static Params create() {
        return DEFAULT_INSTANCE;
    }

    public static Params from(Param<?> ... ps) {
        List<Param<?>> paramsToAdd = Arrays.asList(ps);
        List<Param<Param<?>>> paramsDefaults = Arrays.asList(DEFAULTS);
        if (paramsDefaults.containsAll(paramsToAdd)) {
            return Params.create();
        }
        Param[] paramsAll = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        paramsToAdd.forEach(p -> {
            paramsAll[p.id()] = p;
        });
        return new Params(paramsAll);
    }

    public static void writeObject(ObjectOutput output, Params params) throws IOException {
        Param.PersistenceMode persistenceMode = (Param.PersistenceMode)params.get(0).get();
        Param.LockingMode lockingMode = (Param.LockingMode)params.get(1).get();
        Param.ExecutionMode executionMode = (Param.ExecutionMode)params.get(2).get();
        int paramBits = persistenceMode.ordinal() | lockingMode.ordinal() << 1 | executionMode.ordinal() << 2;
        output.writeByte(paramBits);
    }

    public static Params readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte paramBits = input.readByte();
        Param.PersistenceMode persistenceMode = Param.PersistenceMode.valueOf(paramBits & 1);
        Param.LockingMode lockingMode = Param.LockingMode.valueOf(paramBits >>> 1 & 1);
        Param.ExecutionMode executionMode = Param.ExecutionMode.valueOf(paramBits >>> 2 & 3);
        if (persistenceMode == Param.PersistenceMode.defaultValue() && lockingMode == Param.LockingMode.defaultValue() && executionMode == Param.ExecutionMode.defaultValue()) {
            return DEFAULT_INSTANCE;
        }
        Param<?>[] params = Arrays.copyOf(DEFAULTS, DEFAULTS.length);
        params[0] = persistenceMode;
        params[1] = lockingMode;
        params[2] = executionMode;
        return new Params(params);
    }

    static {
        if (Param.PersistenceMode.values().length > 2) {
            throw new IllegalStateException();
        }
        if (Param.LockingMode.values().length > 2) {
            throw new IllegalStateException();
        }
        if (Param.ExecutionMode.values().length > 4) {
            throw new IllegalStateException();
        }
    }
}

