/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceNotFoundException;

public final class SyncModelOperationHandlerWrapper
implements OperationStepHandler {
    private final PathElement hostElement;
    private final OperationStepHandler delegate;

    public static OperationStepHandler wrapHandler(String localHostName, String operationName, PathAddress address, OperationEntry entry) {
        PathElement element;
        if (entry.getFlags().contains(OperationEntry.Flag.READ_ONLY) || entry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) {
            return entry.getOperationHandler();
        }
        int size = address.size();
        if (size == 0 && "composite".equals(operationName)) {
            return new WrappedCompositeOperationHandler(localHostName);
        }
        if (size == 1) {
            PathElement element2 = address.getElement(0);
            if ("server-group".equals(element2.getKey())) {
                return new SyncModelOperationHandlerWrapper(localHostName, entry.getOperationHandler());
            }
            if (("profile".equals(element2.getKey()) || "socket-binding-group".equals(element2.getKey())) && "write-attribute".equals(operationName)) {
                return new SyncModelOperationHandlerWrapper(localHostName, entry.getOperationHandler());
            }
        } else if (size == 2 && "server-config".equals((element = address.getElement(1)).getKey())) {
            return new SyncModelOperationHandlerWrapper(localHostName, entry.getOperationHandler());
        }
        return entry.getOperationHandler();
    }

    private SyncModelOperationHandlerWrapper(String localHostName, OperationStepHandler delegate) {
        this.hostElement = PathElement.pathElement((String)"host", (String)localHostName);
        this.delegate = delegate;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource original = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        this.delegate.execute(context, operation);
        assert (!context.isBooting());
        if (context.isBooting()) {
            return;
        }
        Resource domain = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        if (SyncModelOperationHandlerWrapper.syncWithMaster(domain, this.hostElement)) {
            MasterDomainControllerClient masterDomainControllerClient = null;
            try {
                masterDomainControllerClient = (MasterDomainControllerClient)context.getServiceRegistry(false).getRequiredService(MasterDomainControllerClient.SERVICE_NAME).getValue();
            }
            catch (ServiceNotFoundException e) {
                if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
                    return;
                }
                throw e;
            }
            masterDomainControllerClient.fetchAndSyncMissingConfiguration(context, original);
        }
    }

    private static boolean syncWithMaster(Resource domain, PathElement hostElement) {
        ModelNode model;
        Resource host = domain.getChild(hostElement);
        assert (host != null);
        HashSet<String> profiles = new HashSet<String>();
        HashSet<String> serverGroups = new HashSet<String>();
        HashSet<String> socketBindings = new HashSet<String>();
        HashMap serversByGroup = new HashMap();
        for (Resource.ResourceEntry serverConfig : host.getChildren("server-config")) {
            model = serverConfig.getModel();
            String group = model.require("group").asString();
            if (!serverGroups.contains(group)) {
                serverGroups.add(group);
            }
            if (!model.hasDefined("socket-binding-group")) continue;
            SyncModelOperationHandlerWrapper.processSocketBindingGroup(domain, model.require("socket-binding-group").asString(), socketBindings);
        }
        for (Resource.ResourceEntry serverGroup : domain.getChildren("server-group")) {
            if (!serverGroups.remove(serverGroup.getName())) {
                return true;
            }
            model = serverGroup.getModel();
            String profile = model.require("profile").asString();
            SyncModelOperationHandlerWrapper.processProfile(domain, profile, profiles);
            SyncModelOperationHandlerWrapper.processSocketBindingGroup(domain, model.require("socket-binding-group").asString(), socketBindings);
        }
        if (!serverGroups.isEmpty()) {
            return true;
        }
        for (Resource.ResourceEntry profile : domain.getChildren("profile")) {
            if (profiles.remove(profile.getName())) continue;
            return true;
        }
        if (!profiles.isEmpty()) {
            return true;
        }
        for (Resource.ResourceEntry socketBindingGroup : domain.getChildren("socket-binding-group")) {
            if (socketBindings.remove(socketBindingGroup.getName())) continue;
            return true;
        }
        return !socketBindings.isEmpty();
    }

    static void processProfile(Resource domain, String profile, Set<String> profiles) {
        if (!profiles.contains(profile)) {
            Resource resource;
            ModelNode model;
            profiles.add(profile);
            PathElement pathElement = PathElement.pathElement((String)"profile", (String)profile);
            if (domain.hasChild(pathElement) && (model = (resource = domain.getChild(pathElement)).getModel()).hasDefined("includes")) {
                for (ModelNode include : model.get("includes").asList()) {
                    SyncModelOperationHandlerWrapper.processProfile(domain, include.asString(), profiles);
                }
            }
        }
    }

    static void processSocketBindingGroup(Resource domain, String name, Set<String> socketBindings) {
        if (!socketBindings.contains(name)) {
            Resource resource;
            ModelNode model;
            socketBindings.add(name);
            PathElement pathElement = PathElement.pathElement((String)"socket-binding-group", (String)name);
            if (domain.hasChild(pathElement) && (model = (resource = domain.getChild(pathElement)).getModel()).hasDefined("includes")) {
                for (ModelNode include : model.get("includes").asList()) {
                    SyncModelOperationHandlerWrapper.processSocketBindingGroup(domain, include.asString(), socketBindings);
                }
            }
        }
    }

    static class WrappedCompositeOperationHandler
    extends CompositeOperationHandler {
        private final String hostName;

        WrappedCompositeOperationHandler(String hostName) {
            this.hostName = hostName;
        }

        protected MultistepUtil.OperationHandlerResolver getOperationHandlerResolver() {
            return new MultistepUtil.OperationHandlerResolver(){

                public OperationStepHandler getOperationStepHandler(String operationName, PathAddress address, ModelNode operation, OperationEntry operationEntry) {
                    return SyncModelOperationHandlerWrapper.wrapHandler(hostName, operationName, address, operationEntry);
                }
            };
        }
    }
}

