/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public abstract class AbstractDiscoveryOptionRemoveHandler
extends AbstractRemoveStepHandler {
    public static final String OPERATION_NAME = "remove";

    protected void updateOptionsAttribute(OperationContext context, ModelNode operation, String type) {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress discoveryOptionsAddress = operationAddress.subAddress(0, operationAddress.size() - 1);
        ModelNode discoveryOptions = Resource.Tools.readModel((Resource)context.readResourceFromRoot(discoveryOptionsAddress));
        ModelNode currentList = discoveryOptions.get("options");
        String name = operationAddress.getLastElement().getValue();
        ModelNode newList = new ModelNode().setEmptyList();
        for (ModelNode e : currentList.asList()) {
            Property prop = e.asProperty();
            String discoveryOptionType = prop.getName();
            String discoveryOptionName = prop.getValue().get("name").asString();
            if (discoveryOptionType.equals(type) && discoveryOptionName.equals(name)) continue;
            newList.add(e);
        }
        ModelNode writeOp = Util.getWriteAttributeOperation((PathAddress)discoveryOptionsAddress, (String)"options", (ModelNode)newList);
        OperationStepHandler writeHandler = context.getRootResourceRegistration().getSubModel(discoveryOptionsAddress).getOperationHandler(PathAddress.EMPTY_ADDRESS, "write-attribute");
        context.addStep(writeOp, writeHandler, OperationContext.Stage.MODEL);
    }
}

