/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.completer.CompleterData;
import org.jboss.aesh.cl.completer.DefaultValueOptionCompleter;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.AeshCommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.parser.ParsedCompleteObject;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalString;

public class AeshCommandLineCompletionParser
implements CommandLineCompletionParser {
    private final AeshCommandLineParser<? extends Command> parser;

    public AeshCommandLineCompletionParser(AeshCommandLineParser<? extends Command> parser) {
        this.parser = parser;
    }

    @Override
    public ParsedCompleteObject findCompleteObject(String line, int cursor) throws CommandLineParserException {
        if (cursor < line.length()) {
            line = line.substring(0, cursor);
        }
        this.parser.clear();
        if (Parser.findIfWordEndWithSpace(line)) {
            return this.endsWithSpace(line);
        }
        return this.optionFinder(line);
    }

    private ParsedCompleteObject endsWithSpace(String line) throws CommandLineParserException {
        String lastWord;
        CommandLine<Command> cl = this.parser.parse(line, true);
        if (this.parser.isGroupCommand()) {
            if (line.trim().equals(this.parser.getProcessedCommand().getName() + " " + cl.getParser().getProcessedCommand().getName())) {
                if (cl.getParser().getProcessedCommand().getArgument() == null) {
                    return new ParsedCompleteObject(true, "", 0, cl.getParser().getCompletionParser());
                }
                return new ParsedCompleteObject(null, "", cl.getParser().getProcessedCommand().getArgument().getType(), false, this.getCorrectCompletionParser(line));
            }
        } else if (line.trim().equals(cl.getParser().getProcessedCommand().getName())) {
            if (cl.getParser().getProcessedCommand().getArgument() == null) {
                return new ParsedCompleteObject(true, "", 0, cl.getParser().getCompletionParser());
            }
            return new ParsedCompleteObject(null, "", cl.getParser().getProcessedCommand().getArgument().getType(), false, this.getCorrectCompletionParser(line));
        }
        if ((lastWord = Parser.findEscapedSpaceWordCloseToEnd(line.trim())).startsWith("-")) {
            int offset = lastWord.length();
            while (lastWord.startsWith("-")) {
                lastWord = lastWord.substring(1);
            }
            if (lastWord.length() == 0) {
                return new ParsedCompleteObject(false, null, offset, this.getCorrectCompletionParser(line));
            }
            if (cl.getParser().getProcessedCommand().findOptionNoActivatorCheck(lastWord) != null || cl.getParser().getProcessedCommand().findLongOptionNoActivatorCheck(lastWord) != null) {
                return this.findCompleteObjectValue(line, true);
            }
            return new ParsedCompleteObject(false, null, offset, this.getCorrectCompletionParser(line));
        }
        return this.findCompleteObjectValue(line, true);
    }

    private ParsedCompleteObject optionFinder(String line) throws CommandLineParserException {
        String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line);
        if (lastWord.startsWith("-")) {
            String secLastWord = Parser.findEscapedSpaceWordCloseToEnd(line.substring(0, line.length() - lastWord.length()));
            if (secLastWord.startsWith("-")) {
                return this.findCompleteObjectValue(line, false);
            }
            switch (lastWord) {
                case "-": {
                    return new ParsedCompleteObject(true, "", 1, this.getCorrectCompletionParser(line));
                }
                case "--": {
                    return new ParsedCompleteObject(true, "", 2, this.getCorrectCompletionParser(line));
                }
            }
            if (!lastWord.startsWith("--") && lastWord.length() == 2) {
                return new ParsedCompleteObject(true, Parser.trimOptionName(lastWord), lastWord.length(), true, this.getCorrectCompletionParser(line));
            }
            String optionName = Parser.trimOptionName(lastWord);
            CommandLine<Command> cl = this.parser.parse(line, true);
            if (cl.getParser().getProcessedCommand().hasUniqueLongOption(optionName)) {
                return new ParsedCompleteObject(true, optionName, lastWord.length(), true, cl.getParser().getCompletionParser());
            }
            return new ParsedCompleteObject(true, optionName, lastWord.length(), false, cl.getParser().getCompletionParser());
        }
        return this.findCompleteObjectValue(line, false);
    }

    private ParsedCompleteObject findCompleteObjectValue(String line, boolean endsWithSpace) throws CommandLineParserException {
        CommandLine<Command> cl = this.parser.parse(line, true);
        if (cl.getArgument() != null && !cl.getArgument().getValues().isEmpty()) {
            return new ParsedCompleteObject("", endsWithSpace ? "" : cl.getArgument().getValues().get(cl.getArgument().getValues().size() - 1), cl.getArgument().getType(), false, cl.getParser().getCompletionParser());
        }
        if (cl.getOptions() != null && cl.getOptions().size() > 0) {
            ProcessedOption po = cl.getOptions().get(cl.getOptions().size() - 1);
            if (po.getEndsWithSeparator()) {
                endsWithSpace = true;
            }
            if (endsWithSpace && po.getValue() != null && po.getValue().length() > 0 && (po.getOptionType() == OptionType.NORMAL || po.getOptionType() == OptionType.BOOLEAN)) {
                if (cl.getArgument() == null) {
                    return new ParsedCompleteObject(true, "", 0, cl.getParser().getCompletionParser());
                }
                return new ParsedCompleteObject(true, cl.getParser().getCompletionParser());
            }
            if (po.isLongNameUsed() || po.getShortName() == null || po.getShortName().length() < 1) {
                return new ParsedCompleteObject(po.getName(), endsWithSpace ? "" : po.getValues().get(po.getValues().size() - 1), po.getType(), true, cl.getParser().getCompletionParser());
            }
            return new ParsedCompleteObject(po.getShortName(), endsWithSpace ? "" : po.getValues().get(po.getValues().size() - 1), po.getType(), true, cl.getParser().getCompletionParser());
        }
        return new ParsedCompleteObject(true, "", 0, this.getCorrectCompletionParser(line));
    }

    @Override
    public void injectValuesAndComplete(ParsedCompleteObject completeObject, CompleteOperation completeOperation, InvocationProviders invocationProviders) {
        if (completeObject.doDisplayOptions()) {
            if (completeObject.isCompleteOptionName()) {
                completeOperation.addCompletionCandidate("");
            } else if (completeObject.getName() != null && completeObject.getName().length() > 0) {
                String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().lastIndexOf(completeObject.getName()));
                List<String> words = Parser.findAllWords(rest).getWords();
                try {
                    this.parser.getCommandPopulator().populateObject(this.parser.parse(words, true), invocationProviders, completeOperation.getAeshContext(), false);
                }
                catch (CommandLineParserException | OptionValidatorException exception) {
                    // empty catch block
                }
                List<TerminalString> optionNamesWithDash = this.parser.getProcessedCommand().findPossibleLongNamesWitdDash(completeObject.getName());
                if (optionNamesWithDash.size() > 0) {
                    if (optionNamesWithDash.size() == 1) {
                        completeOperation.addCompletionCandidate(optionNamesWithDash.get(0));
                        completeOperation.setOffset(completeOperation.getCursor() - 2 - completeObject.getName().length());
                    } else {
                        completeOperation.addCompletionCandidatesTerminalString(optionNamesWithDash);
                        completeOperation.setOffset(completeOperation.getCursor() - 2 - completeObject.getName().length());
                    }
                }
            } else {
                try {
                    List<String> words = Parser.findAllWords(completeOperation.getBuffer()).getWords();
                    if (words.get(words.size() - 1).equals("--") || words.get(words.size() - 1).equals("-")) {
                        words.remove(words.size() - 1);
                    }
                    this.parser.getCommandPopulator().populateObject(this.parser.parse(words, true), invocationProviders, completeOperation.getAeshContext(), false);
                }
                catch (CommandLineParserException | OptionValidatorException words) {
                    // empty catch block
                }
                List<TerminalString> optionNamesWithDash = this.parser.getProcessedCommand().getOptionLongNamesWithDash();
                if (optionNamesWithDash.size() > 1) {
                    completeOperation.addCompletionCandidatesTerminalString(optionNamesWithDash);
                } else if (optionNamesWithDash.size() == 1) {
                    int count = 0;
                    if (completeOperation.getCursor() < completeOperation.getBuffer().length()) {
                        String line = completeOperation.getBuffer().substring(0, completeOperation.getCursor());
                        while (line.substring(0, line.length() - count).endsWith("-")) {
                            ++count;
                        }
                    } else {
                        while (completeOperation.getBuffer().substring(0, completeOperation.getBuffer().length() - count).endsWith("-")) {
                            ++count;
                        }
                    }
                    completeOperation.addCompletionCandidate(optionNamesWithDash.get(0));
                    completeOperation.setOffset(completeOperation.getCursor() - count);
                }
            }
        } else if (completeObject.isOption()) {
            Object completions;
            String displayName;
            ProcessedOption currentOption = this.parser.getProcessedCommand().findOption(completeObject.getName());
            if (currentOption == null) {
                currentOption = this.parser.getProcessedCommand().findLongOptionNoActivatorCheck(completeObject.getName());
            }
            if ((displayName = currentOption.getDisplayName()) == null) {
                return;
            }
            String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().lastIndexOf(displayName));
            try {
                List<String> words = Parser.findAllWords(rest).getWords();
                this.parser.getCommandPopulator().populateObject(this.parser.parse(words, true), invocationProviders, completeOperation.getAeshContext(), false);
            }
            catch (CommandLineParserException | OptionValidatorException words) {
                // empty catch block
            }
            if (currentOption.getCompleter() != null && currentOption.getActivator().isActivated(this.parser.getProcessedCommand())) {
                completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), this.parser.getCommand()));
                currentOption.getCompleter().complete(completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                this.completionSetOffSet(completeObject, completeOperation, (CompleterInvocation)completions);
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            } else if (currentOption.getDefaultValues().size() > 0) {
                completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), this.parser.getCommand()));
                new DefaultValueOptionCompleter(currentOption.getDefaultValues()).complete((CompleterInvocation)completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                this.completionSetOffSet(completeObject, completeOperation, (CompleterInvocation)completions);
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            }
        } else if (completeObject.isArgument()) {
            Object completions;
            String lastWord = Parser.findEscapedSpaceWordCloseToEnd(completeOperation.getBuffer());
            String rest = completeOperation.getBuffer().substring(0, completeOperation.getBuffer().length() - lastWord.length());
            try {
                List<String> words = Parser.findAllWords(rest).getWords();
                this.parser.getCommandPopulator().populateObject(this.parser.parse(words, true), invocationProviders, completeOperation.getAeshContext(), false);
            }
            catch (CommandLineParserException | OptionValidatorException words) {
                // empty catch block
            }
            if (this.parser.getProcessedCommand().getArgument() != null && this.parser.getProcessedCommand().getArgument().getCompleter() != null) {
                completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), this.parser.getCommand()));
                this.parser.getProcessedCommand().getArgument().getCompleter().complete(completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                this.completionSetOffSet(completeObject, completeOperation, (CompleterInvocation)completions);
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                    completeOperation.doAppendSeparator(completions.isAppendSpace());
                }
            } else if (this.parser.getProcessedCommand().containsArgumentWithDefaultValues()) {
                completions = invocationProviders.getCompleterProvider().enhanceCompleterInvocation(new CompleterData(completeOperation.getAeshContext(), completeObject.getValue(), this.parser.getCommand()));
                new DefaultValueOptionCompleter(this.parser.getProcessedCommand().getArgument().getDefaultValues()).complete((CompleterInvocation)completions);
                completeOperation.addCompletionCandidatesTerminalString(completions.getCompleterValues());
                this.completionSetOffSet(completeObject, completeOperation, (CompleterInvocation)completions);
                completeOperation.setIgnoreOffset(completions.doIgnoreOffset());
                completeOperation.setIgnoreStartsWith(completions.isIgnoreStartsWith());
                if (completions.getCompleterValues().size() == 1) {
                    if (completeObject.getValue().indexOf(32) > 0) {
                        completeOperation.setOffset(completeOperation.getCursor() - (completeObject.getOffset() + Parser.findNumberOfSpacesInWord(completeObject.getValue())));
                    }
                    if (completeOperation.getCompletionCandidates().get(0).containSpaces()) {
                        completeOperation.getCompletionCandidates().get(0).switchSpacesToEscapedSpaces();
                    }
                }
                completeOperation.doAppendSeparator(completions.isAppendSpace());
            }
        }
    }

    private void completionSetOffSet(ParsedCompleteObject completeObject, CompleteOperation completeOperation, CompleterInvocation completions) {
        if (completions.getOffset() > 0) {
            completeOperation.setOffset(completeOperation.getCursor() - completions.getOffset());
        } else if (completeObject.getValue() != null) {
            completeOperation.setOffset(completeOperation.getCursor() - completeObject.getValue().length());
        }
    }

    private CommandLineCompletionParser getCorrectCompletionParser(String line) {
        if (!this.parser.isGroupCommand()) {
            return this;
        }
        String childLine = line.trim().substring(this.parser.getProcessedCommand().getName().length());
        String child = Parser.findFirstWord(childLine);
        CommandLineParser<Command> childParser = this.parser.getChildParser(child);
        if (childParser != null) {
            return childParser.getCompletionParser();
        }
        return this;
    }
}

