/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jms.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.jms.impl.JmsBackendQueueProcessor;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JmsBackendQueueTask
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final Collection<LuceneWork> queue;
    private final JmsBackendQueueProcessor processor;
    private final String indexName;
    private final IndexManager indexManager;

    public JmsBackendQueueTask(String indexName, Collection<LuceneWork> queue, IndexManager indexManager, JmsBackendQueueProcessor jmsBackendQueueProcessor) {
        this.indexName = indexName;
        this.queue = queue;
        this.indexManager = indexManager;
        this.processor = jmsBackendQueueProcessor;
    }

    @Override
    public void run() {
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(this.queue);
        for (LuceneWork work : this.queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (filteredQueue.size() == 0) {
            return;
        }
        LuceneWorkSerializer serializer = this.indexManager.getSerializer();
        byte[] data = serializer.toSerializedModel(filteredQueue);
        QueueSession session = null;
        QueueConnection connection = null;
        try {
            connection = this.processor.getJMSConnection();
            session = connection.createQueueSession(this.processor.isTransactional(), 3);
            ObjectMessage message = session.createObjectMessage();
            message.setObject((Serializable)data);
            message.setStringProperty("JMSXGroupID", this.indexName);
            if (log.isDebugEnabled()) {
                JmsBackendQueueTask.attachDebugDetails(message, this.indexName);
            }
            QueueSender sender = session.createSender(this.processor.getJmsQueue());
            sender.send((Message)message);
            sender.close();
            session.close();
        }
        catch (JMSException e) {
            throw log.unableToSendJMSWork(this.indexName, this.processor.getJmsQueueName(), (Throwable)e);
        }
        finally {
            this.processor.releaseJMSConnection(connection);
        }
    }

    private static void attachDebugDetails(ObjectMessage message, String indexName) throws JMSException {
        String randomUUID = UUID.randomUUID().toString();
        message.setStringProperty("HSearchMsgId", randomUUID);
        log.debug((Object)("Enqueueing List<LuceneWork> for index '" + indexName + "' having id " + randomUUID));
    }
}

