/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParametersTransformer;
import org.hibernate.search.elasticsearch.settings.impl.translation.StringParameterValueTransformer;

class SimpleParametersTransformer
implements ParametersTransformer {
    private final Map<String, String> parameterNameTranslations;
    private final Map<String, ParameterValueTransformer> parameterValueTranslations;

    public SimpleParametersTransformer(Map<String, String> parameterNameTranslations, Map<String, ParameterValueTransformer> parameterValueTranslations) {
        this.parameterNameTranslations = parameterNameTranslations;
        this.parameterValueTranslations = parameterValueTranslations;
    }

    @Override
    public Map<String, JsonElement> transform(Map<String, String> luceneParameters) {
        if (luceneParameters.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, JsonElement> result = new LinkedHashMap<String, JsonElement>();
        for (Map.Entry<String, String> entry : luceneParameters.entrySet()) {
            this.addParameter(result, entry.getKey(), entry.getValue());
        }
        luceneParameters.clear();
        return result;
    }

    protected void addParameter(Map<String, JsonElement> parameterMap, String luceneParameterName, String value) {
        ParameterValueTransformer valueTransformer;
        String elasticsearchParameterName = this.parameterNameTranslations.get(luceneParameterName);
        if (elasticsearchParameterName == null) {
            elasticsearchParameterName = luceneParameterName;
        }
        if ((valueTransformer = this.parameterValueTranslations.get(luceneParameterName)) == null) {
            valueTransformer = StringParameterValueTransformer.INSTANCE;
        }
        parameterMap.put(elasticsearchParameterName, valueTransformer.transform(value));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "parameterNameTranslations = " + this.parameterNameTranslations + ", parameterValueTranslations = " + this.parameterValueTranslations + "]";
    }
}

