/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.blocktree.Lucene40FieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.Outputs;

@Deprecated
public final class Lucene40BlockTreeTermsReader
extends FieldsProducer {
    static final String TERMS_EXTENSION = "tim";
    static final String TERMS_CODEC_NAME = "BLOCK_TREE_TERMS_DICT";
    public static final int VERSION_START = 0;
    public static final int VERSION_APPEND_ONLY = 1;
    public static final int VERSION_META_ARRAY = 2;
    public static final int VERSION_CHECKSUM = 3;
    public static final int VERSION_MIN_MAX_TERMS = 4;
    public static final int VERSION_CURRENT = 4;
    static final String TERMS_INDEX_EXTENSION = "tip";
    static final String TERMS_INDEX_CODEC_NAME = "BLOCK_TREE_TERMS_INDEX";
    static final int OUTPUT_FLAGS_NUM_BITS = 2;
    static final int OUTPUT_FLAGS_MASK = 3;
    static final int OUTPUT_FLAG_IS_FLOOR = 1;
    static final int OUTPUT_FLAG_HAS_TERMS = 2;
    static final Outputs<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = (BytesRef)FST_OUTPUTS.getNoOutput();
    final IndexInput in;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, Lucene40FieldReader> fields = new TreeMap();
    private long dirOffset;
    private long indexDirOffset;
    final String segment;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene40BlockTreeTermsReader(PostingsReaderBase postingsReader, SegmentReadState state) throws IOException {
        this.postingsReader = postingsReader;
        this.segment = state.segmentInfo.name;
        String termsFileName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.in = state.directory.openInput(termsFileName, state.context);
        boolean success = false;
        IndexInput indexIn = null;
        try {
            this.version = this.readHeader(this.in);
            String indexFileName = IndexFileNames.segmentFileName((String)this.segment, (String)state.segmentSuffix, (String)TERMS_INDEX_EXTENSION);
            indexIn = state.directory.openInput(indexFileName, state.context);
            int indexVersion = this.readIndexHeader(indexIn);
            if (indexVersion != this.version) {
                throw new CorruptIndexException("mixmatched version files: " + this.in + "=" + this.version + "," + indexIn + "=" + indexVersion, (DataInput)indexIn);
            }
            if (this.version >= 3) {
                CodecUtil.checksumEntireFile((IndexInput)indexIn);
            }
            postingsReader.init(this.in, state);
            if (this.version >= 3) {
                CodecUtil.retrieveChecksum((IndexInput)this.in);
            }
            this.seekDir(this.in, this.dirOffset);
            this.seekDir(indexIn, this.indexDirOffset);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields, (DataInput)this.in);
            }
            for (int i = 0; i < numFields; ++i) {
                BytesRef maxTerm;
                BytesRef minTerm;
                int longsSize;
                int field = this.in.readVInt();
                long numTerms = this.in.readVLong();
                if (numTerms <= 0L) {
                    throw new CorruptIndexException("Illegal numTerms for field number: " + field, (DataInput)this.in);
                }
                int numBytes = this.in.readVInt();
                if (numBytes < 0) {
                    throw new CorruptIndexException("invalid rootCode for field number: " + field + ", numBytes=" + numBytes, (DataInput)this.in);
                }
                BytesRef rootCode = new BytesRef(new byte[numBytes]);
                this.in.readBytes(rootCode.bytes, 0, numBytes);
                rootCode.length = numBytes;
                FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field);
                if (fieldInfo == null) {
                    throw new CorruptIndexException("invalid field number: " + field, (DataInput)this.in);
                }
                long sumTotalTermFreq = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? -1L : this.in.readVLong();
                long sumDocFreq = this.in.readVLong();
                int docCount = this.in.readVInt();
                int n = longsSize = this.version >= 2 ? this.in.readVInt() : 0;
                if (longsSize < 0) {
                    throw new CorruptIndexException("invalid longsSize for field: " + fieldInfo.name + ", longsSize=" + longsSize, (DataInput)this.in);
                }
                if (this.version >= 4) {
                    minTerm = Lucene40BlockTreeTermsReader.readBytesRef(this.in);
                    maxTerm = Lucene40BlockTreeTermsReader.readBytesRef(this.in);
                } else {
                    maxTerm = null;
                    minTerm = null;
                }
                if (docCount < 0 || docCount > state.segmentInfo.maxDoc()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + state.segmentInfo.maxDoc(), (DataInput)this.in);
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount, (DataInput)this.in);
                }
                if (sumTotalTermFreq != -1L && sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq, (DataInput)this.in);
                }
                long indexStartFP = indexIn.readVLong();
                Lucene40FieldReader previous = this.fields.put(fieldInfo.name, new Lucene40FieldReader(this, fieldInfo, numTerms, rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, (DataInput)this.in);
            }
            indexIn.close();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexIn, this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        BytesRef bytes = new BytesRef();
        bytes.length = in.readVInt();
        bytes.bytes = new byte[bytes.length];
        in.readBytes(bytes.bytes, 0, bytes.length);
        return bytes;
    }

    private int readHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)TERMS_CODEC_NAME, (int)0, (int)4);
        if (version < 1) {
            this.dirOffset = input.readLong();
        }
        return version;
    }

    private int readIndexHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)TERMS_INDEX_CODEC_NAME, (int)0, (int)4);
        if (version < 1) {
            this.indexDirOffset = input.readLong();
        }
        return version;
    }

    private void seekDir(IndexInput input, long dirOffset) throws IOException {
        if (this.version >= 3) {
            input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
            dirOffset = input.readLong();
        } else if (this.version >= 1) {
            input.seek(input.length() - 8L);
            dirOffset = input.readLong();
        }
        input.seek(dirOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in, this.postingsReader});
        }
        finally {
            this.fields.clear();
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    public long ramBytesUsed() {
        long sizeInBytes = this.postingsReader.ramBytesUsed();
        for (Lucene40FieldReader reader : this.fields.values()) {
            sizeInBytes += reader.ramBytesUsed();
        }
        return sizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables((String)"field", this.fields));
        resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.postingsReader));
        return Collections.unmodifiableList(resources);
    }

    public void checkIntegrity() throws IOException {
        if (this.version >= 3) {
            CodecUtil.checksumEntireFile((IndexInput)this.in);
            this.postingsReader.checkIntegrity();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader + ")";
    }
}

