/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.h2.util.New;

public class DataUtils {
    public static final int ERROR_READING_FAILED = 1;
    public static final int ERROR_WRITING_FAILED = 2;
    public static final int ERROR_INTERNAL = 3;
    public static final int ERROR_CLOSED = 4;
    public static final int ERROR_UNSUPPORTED_FORMAT = 5;
    public static final int ERROR_FILE_CORRUPT = 6;
    public static final int ERROR_FILE_LOCKED = 7;
    public static final int ERROR_SERIALIZATION = 8;
    public static final int ERROR_TRANSACTION_CORRUPT = 100;
    public static final int ERROR_TRANSACTION_LOCK_TIMEOUT = 101;
    public static final int PAGE_TYPE_LEAF = 0;
    public static final int PAGE_TYPE_NODE = 1;
    public static final int PAGE_COMPRESSED = 2;
    public static final int MAX_VAR_INT_LEN = 5;
    public static final int MAX_VAR_LONG_LEN = 10;
    public static final int COMPRESSED_VAR_INT_MAX = 0x1FFFFF;
    public static final long COMPRESSED_VAR_LONG_MAX = 0x1FFFFFFFFFFFFL;
    public static final int PAGE_MEMORY = 128;
    public static final int PAGE_MEMORY_CHILD = 16;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int MAX_GROW = 0x1000000;

    public static int getVarIntLen(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int getVarLongLen(long l) {
        int n = 1;
        while ((l >>>= 7) != 0L) {
            ++n;
        }
        return n;
    }

    public static int readVarInt(ByteBuffer byteBuffer) {
        byte by = byteBuffer.get();
        if (by >= 0) {
            return by;
        }
        return DataUtils.readVarIntRest(byteBuffer, by);
    }

    private static int readVarIntRest(ByteBuffer byteBuffer, int n) {
        int n2 = n & 0x7F;
        n = byteBuffer.get();
        if (n >= 0) {
            return n2 | n << 7;
        }
        n2 |= (n & 0x7F) << 7;
        n = byteBuffer.get();
        if (n >= 0) {
            return n2 | n << 14;
        }
        n2 |= (n & 0x7F) << 14;
        n = byteBuffer.get();
        if (n >= 0) {
            return n2 | n << 21;
        }
        return n2 |= (n & 0x7F) << 21 | byteBuffer.get() << 28;
    }

    public static long readVarLong(ByteBuffer byteBuffer) {
        long l = byteBuffer.get();
        if (l >= 0L) {
            return l;
        }
        l &= 0x7FL;
        for (int i = 7; i < 64; i += 7) {
            long l2 = byteBuffer.get();
            l |= (l2 & 0x7FL) << i;
            if (l2 >= 0L) break;
        }
        return l;
    }

    public static void writeVarInt(OutputStream outputStream, int n) throws IOException {
        while ((n & 0xFFFFFF80) != 0) {
            outputStream.write((byte)(0x80 | n & 0x7F));
            n >>>= 7;
        }
        outputStream.write((byte)n);
    }

    public static void writeVarInt(ByteBuffer byteBuffer, int n) {
        while ((n & 0xFFFFFF80) != 0) {
            byteBuffer.put((byte)(0x80 | n & 0x7F));
            n >>>= 7;
        }
        byteBuffer.put((byte)n);
    }

    public static ByteBuffer writeStringData(ByteBuffer byteBuffer, String string, int n) {
        byteBuffer = DataUtils.ensureCapacity(byteBuffer, 3 * n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c >= '\u0800') {
                byteBuffer.put((byte)(0xE0 | c >> 12));
                byteBuffer.put((byte)(c >> 6 & 0x3F));
                byteBuffer.put((byte)(c & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c >> 6));
            byteBuffer.put((byte)(c & 0x3F));
        }
        return byteBuffer;
    }

    public static String readString(ByteBuffer byteBuffer, int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.get() & 0xFF;
            cArray[i] = n2 < 128 ? (char)n2 : (n2 >= 224 ? (char)(((n2 & 0xF) << 12) + ((byteBuffer.get() & 0x3F) << 6) + (byteBuffer.get() & 0x3F)) : (char)(((n2 & 0x1F) << 6) + (byteBuffer.get() & 0x3F)));
        }
        return new String(cArray);
    }

    public static void writeVarLong(ByteBuffer byteBuffer, long l) {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byteBuffer.put((byte)(0x80L | l & 0x7FL));
            l >>>= 7;
        }
        byteBuffer.put((byte)l);
    }

    public static void writeVarLong(OutputStream outputStream, long l) throws IOException {
        while ((l & 0xFFFFFFFFFFFFFF80L) != 0L) {
            outputStream.write((byte)(0x80L | l & 0x7FL));
            l >>>= 7;
        }
        outputStream.write((byte)l);
    }

    public static void copyWithGap(Object object, Object object2, int n, int n2) {
        if (n2 > 0) {
            System.arraycopy(object, 0, object2, 0, n2);
        }
        if (n2 < n) {
            System.arraycopy(object, n2, object2, n2 + 1, n - n2);
        }
    }

    public static void copyExcept(Object object, Object object2, int n, int n2) {
        if (n2 > 0 && n > 0) {
            System.arraycopy(object, 0, object2, 0, n2);
        }
        if (n2 < n) {
            System.arraycopy(object, n2 + 1, object2, n2, n - n2 - 1);
        }
    }

    public static void readFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) {
        try {
            do {
                int n;
                if ((n = fileChannel.read(byteBuffer, l)) < 0) {
                    throw new EOFException();
                }
                l += (long)n;
            } while (byteBuffer.remaining() > 0);
            byteBuffer.rewind();
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(1, "Reading from {0} failed; length {1} at {2}", fileChannel, byteBuffer.remaining(), l, iOException);
        }
    }

    public static void writeFully(FileChannel fileChannel, long l, ByteBuffer byteBuffer) {
        try {
            int n = 0;
            do {
                int n2 = fileChannel.write(byteBuffer, l + (long)n);
                n += n2;
            } while (byteBuffer.remaining() > 0);
        }
        catch (IOException iOException) {
            throw DataUtils.newIllegalStateException(2, "Writing to {0} failed; length {1} at {2}", fileChannel, byteBuffer.remaining(), l, iOException);
        }
    }

    public static int encodeLength(int n) {
        if (n <= 32) {
            return 0;
        }
        int n2 = Integer.numberOfLeadingZeros(n);
        int n3 = n << n2 + 1;
        n2 += n2;
        if ((n3 & Integer.MIN_VALUE) != 0) {
            --n2;
        }
        if (n3 << 1 != 0) {
            --n2;
        }
        n2 = Math.min(31, 52 - n2);
        return n2;
    }

    public static int getPageChunkId(long l) {
        return (int)(l >>> 38);
    }

    public static int getPageMaxLength(long l) {
        int n = (int)(l >> 1 & 0x1FL);
        if (n == 31) {
            return Integer.MAX_VALUE;
        }
        return 2 + (n & 1) << (n >> 1) + 4;
    }

    public static int getPageOffset(long l) {
        return (int)(l >> 6);
    }

    public static int getPageType(long l) {
        return (int)l & 1;
    }

    public static long getPagePos(int n, int n2, int n3, int n4) {
        long l = (long)n << 38;
        l |= (long)n2 << 6;
        l |= (long)(DataUtils.encodeLength(n3) << 1);
        return l |= (long)n4;
    }

    public static short getCheckValue(int n) {
        return (short)(n >> 16 ^ n);
    }

    public static StringBuilder appendMap(StringBuilder stringBuilder, HashMap<String, ?> hashMap) {
        ArrayList<String> arrayList = New.arrayList(hashMap.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            DataUtils.appendMap(stringBuilder, string, hashMap.get(string));
        }
        return stringBuilder;
    }

    public static void appendMap(StringBuilder stringBuilder, String string, Object object) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(',');
        }
        stringBuilder.append(string).append(':');
        String string2 = object.toString();
        if (string2.indexOf(44) < 0 && string2.indexOf(34) < 0) {
            stringBuilder.append(object);
        } else {
            stringBuilder.append('\"');
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '\"') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\"');
        }
    }

    public static HashMap<String, String> parseMap(String string) {
        HashMap<String, String> hashMap = New.hashMap();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            int n3 = n;
            if ((n = string.indexOf(58, n)) < 0) {
                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", string);
            }
            String string2 = string.substring(n3, n++);
            StringBuilder stringBuilder = new StringBuilder();
            block1: while (n < n2 && (c = string.charAt(n++)) != ',') {
                if (c == '\"') {
                    while (n < n2) {
                        if ((c = string.charAt(n++)) == '\\') {
                            if (n == n2) {
                                throw DataUtils.newIllegalStateException(6, "Not a map: {0}", string);
                            }
                            c = string.charAt(n++);
                        } else if (c == '\"') continue block1;
                        stringBuilder.append(c);
                    }
                    continue;
                }
                stringBuilder.append(c);
            }
            hashMap.put(string2, stringBuilder.toString());
        }
        return hashMap;
    }

    public static int getFletcher32(byte[] byArray, int n) {
        int n2 = 65535;
        int n3 = 65535;
        int n4 = 0;
        while (n4 < n) {
            int n5 = Math.min(n4 + 718, n);
            while (n4 < n5) {
                int n6 = (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                n3 += (n2 += n6);
            }
            n2 = (n2 & 0xFFFF) + (n2 >>> 16);
            n3 = (n3 & 0xFFFF) + (n3 >>> 16);
        }
        n2 = (n2 & 0xFFFF) + (n2 >>> 16);
        n3 = (n3 & 0xFFFF) + (n3 >>> 16);
        return n3 << 16 | n2;
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw DataUtils.newIllegalArgumentException(string, objectArray);
        }
    }

    public static IllegalArgumentException newIllegalArgumentException(String string, Object ... objectArray) {
        return DataUtils.initCause(new IllegalArgumentException(DataUtils.formatMessage(0, string, objectArray)), objectArray);
    }

    public static UnsupportedOperationException newUnsupportedOperationException(String string) {
        return new UnsupportedOperationException(DataUtils.formatMessage(0, string, new Object[0]));
    }

    public static ConcurrentModificationException newConcurrentModificationException(String string) {
        return new ConcurrentModificationException(DataUtils.formatMessage(0, string, new Object[0]));
    }

    public static IllegalStateException newIllegalStateException(int n, String string, Object ... objectArray) {
        return DataUtils.initCause(new IllegalStateException(DataUtils.formatMessage(n, string, objectArray)), objectArray);
    }

    private static <T extends Exception> T initCause(T t, Object ... objectArray) {
        Object object;
        int n = objectArray.length;
        if (n > 0 && (object = objectArray[n - 1]) instanceof Exception) {
            t.initCause((Exception)object);
        }
        return t;
    }

    private static String formatMessage(int n, String string, Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof Exception) continue;
            objectArray[i] = object == null ? "null" : object.toString();
        }
        return MessageFormat.format(string, objectArray) + " [" + 1 + "." + 3 + "." + 173 + "/" + n + "]";
    }

    public static int getErrorCode(String string) {
        int n;
        if (string.endsWith("]") && (n = string.lastIndexOf(47)) >= 0) {
            String string2 = string.substring(n + 1, string.length() - 1);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static byte[] newBytes(int n) {
        if (n == 0) {
            return EMPTY_BYTES;
        }
        try {
            return new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Requested memory: " + n);
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.remaining() > (n += 1024)) {
            return byteBuffer;
        }
        return DataUtils.grow(byteBuffer, n);
    }

    private static ByteBuffer grow(ByteBuffer byteBuffer, int n) {
        n = byteBuffer.remaining() + n;
        int n2 = byteBuffer.capacity();
        n = Math.max(n, Math.min(n2 + 0x1000000, n2 * 2));
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n);
        byteBuffer.flip();
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }
}

