/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSSlaveDirectoryProvider
implements DirectoryProvider<Directory> {
    private static final Log log = LoggerFactory.make();
    private final Timer timer = new Timer(true);
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private volatile int current;
    private volatile Directory dummyDirectory;
    private FSDirectory directory1;
    private FSDirectory directory2;
    private Path sourceIndexDir;
    private Path indexDir;
    private String directoryProviderName;
    private Properties properties;
    private UpdateTask updateTask;
    private ServiceManager serviceManager;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.serviceManager = context.getServiceManager();
        this.sourceIndexDir = DirectoryProviderHelper.getSourceDirectoryPath(directoryProviderName, properties, false);
        log.debugf("Source directory: %s", this.sourceIndexDir);
        this.indexDir = DirectoryHelper.getVerifiedIndexPath(directoryProviderName, properties, true).normalize();
        log.debugf("Index directory: %s", this.indexDir);
        DirectoryProviderHelper.getCopyBufferSize(directoryProviderName, properties);
        this.current = 0;
    }

    private boolean currentMarkerIsInSource() {
        int retry = ConfigurationParseHelper.getIntValue(this.properties, "retry_marker_lookup", 0);
        if (retry < 0) {
            throw new SearchException("retry_marker_lookup option must be a positive integer, but was \"" + retry + "\"");
        }
        boolean currentMarkerInSource = false;
        for (int tried = 0; tried <= retry; ++tried) {
            if (tried > 0) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = currentMarkerInSource = Files.exists(this.sourceIndexDir.resolve("current1"), new LinkOption[0]) || Files.exists(this.sourceIndexDir.resolve("current2"), new LinkOption[0]);
            if (currentMarkerInSource) break;
        }
        return currentMarkerInSource;
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        if (!this.attemptInitializeAndStart()) {
            long period = DirectoryProviderHelper.getRetryInitializePeriod(this.properties, this.directoryProviderName);
            if (period != 0L) {
                this.scheduleTask(new InitTask(), period);
            } else {
                throw new SearchException("Failed to initialize DirectoryProvider \"" + this.directoryProviderName + "\": could not find marker file in index source");
            }
        }
    }

    private void startIt() {
        int readCurrentState = this.current;
        int currentToBe = 0;
        try {
            this.directory1 = DirectoryProviderHelper.createFSIndex(this.indexDir.resolve("1"), this.properties, this.serviceManager);
            this.directory2 = DirectoryProviderHelper.createFSIndex(this.indexDir.resolve("2"), this.properties, this.serviceManager);
            Path currentMarker = this.indexDir.resolve("current1");
            Path current2Marker = this.indexDir.resolve("current2");
            if (Files.exists(currentMarker, new LinkOption[0])) {
                currentToBe = 1;
                Files.deleteIfExists(current2Marker);
            } else if (Files.exists(current2Marker, new LinkOption[0])) {
                currentToBe = 2;
            } else {
                int sourceCurrent;
                log.debug("Setting directory 1 as current");
                currentToBe = 1;
                Path destinationFile = this.indexDir.resolve(Integer.valueOf(currentToBe).toString());
                if (Files.exists(this.sourceIndexDir.resolve("current1"), new LinkOption[0])) {
                    sourceCurrent = 1;
                } else if (Files.exists(this.sourceIndexDir.resolve("current2"), new LinkOption[0])) {
                    sourceCurrent = 2;
                } else {
                    throw new SearchException("No current file marker found in source directory: " + this.sourceIndexDir);
                }
                try {
                    FileHelper.synchronize(this.sourceIndexDir.resolve(String.valueOf(sourceCurrent)), destinationFile, true);
                }
                catch (IOException e) {
                    throw new SearchException("Unable to synchronize directory: " + this.indexDir.toString(), e);
                }
                Files.createFile(currentMarker, new FileAttribute[0]);
            }
            log.debugf("Current directory: %d", currentToBe);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.directoryProviderName, e);
        }
        this.updateTask = new UpdateTask(this.sourceIndexDir, this.indexDir);
        long period = DirectoryProviderHelper.getRefreshPeriod(this.properties, this.directoryProviderName);
        this.scheduleTask(this.updateTask, period);
        this.current = currentToBe;
        this.started = true;
    }

    @Override
    public Directory getDirectory() {
        if (!this.started) {
            if (this.dummyDirectory == null) {
                RAMDirectory directory = new RAMDirectory();
                DirectoryHelper.initializeIndexIfNeeded((Directory)directory);
                this.dummyDirectory = directory;
            }
            return this.dummyDirectory;
        }
        int readState = this.current;
        if (readState == 1) {
            return this.directory1;
        }
        if (readState == 2) {
            return this.directory2;
        }
        throw new AssertionFailure("Illegal current directory: " + readState);
    }

    public boolean equals(Object obj) {
        throw new AssertionFailure("this type can not be compared reliably");
    }

    public int hashCode() {
        throw new AssertionFailure("this type can not be compared reliably");
    }

    protected synchronized boolean attemptInitializeAndStart() {
        if (!this.initialized) {
            if (this.currentMarkerIsInSource()) {
                this.initialized = true;
                log.foundCurrentMarker();
            } else {
                log.noCurrentMarkerInSourceDirectory();
            }
        }
        if (this.initialized) {
            this.startIt();
        }
        return this.started;
    }

    @Override
    public void stop() {
        int readCurrentState = this.current;
        this.timer.cancel();
        if (this.updateTask != null) {
            this.updateTask.stop();
        }
        this.closeDirectory((Directory)this.directory1);
        this.closeDirectory((Directory)this.directory2);
    }

    private void closeDirectory(Directory directory) {
        if (directory != null) {
            try {
                directory.close();
            }
            catch (Exception e) {
                log.unableToCloseLuceneDirectory(directory, e);
            }
        }
    }

    protected void scheduleTask(TimerTask task, long period) {
        this.timer.schedule(task, period, period);
    }

    class CopyDirectory
    implements Runnable {
        private final Path source;
        private final Path destination;
        private final AtomicBoolean inProgress = new AtomicBoolean(false);

        public CopyDirectory(Path sourceIndexDir, Path destination) {
            this.source = sourceIndexDir;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                Path sourceFile = this.determineCurrentSourceFile();
                if (sourceFile == null) {
                    log.unableToDetermineCurrentInSourceDirectory();
                    return;
                }
                Path currentDestinationFile = this.destination.resolve(Integer.valueOf(FSSlaveDirectoryProvider.this.current).toString());
                try {
                    if (FileHelper.areInSync(sourceFile, currentDestinationFile)) {
                        log.trace("Source and destination directory are in sync. No copying required.");
                        return;
                    }
                }
                catch (IOException ioe) {
                    log.unableToCompareSourceWithDestinationDirectory(sourceFile.toString(), currentDestinationFile.toString());
                }
                int oldIndex = FSSlaveDirectoryProvider.this.current;
                int index = oldIndex == 1 ? 2 : 1;
                Path destinationFile = this.destination.resolve(Integer.valueOf(index).toString());
                try {
                    log.tracef("Copying %s into %s", sourceFile, destinationFile);
                    FileHelper.synchronize(sourceFile, destinationFile, true);
                    FSSlaveDirectoryProvider.this.current = index;
                    log.tracef("Copy for %s took %d ms", FSSlaveDirectoryProvider.this.indexDir, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
                catch (IOException e) {
                    log.unableToSynchronizeSource(FSSlaveDirectoryProvider.this.indexDir.toString(), e);
                    this.inProgress.set(false);
                    return;
                }
                try {
                    Files.delete(FSSlaveDirectoryProvider.this.indexDir.resolve("current" + oldIndex));
                }
                catch (IOException e) {
                    log.unableToRemovePreviousMarker(FSSlaveDirectoryProvider.this.indexDir.toString(), e);
                }
                try {
                    Files.createFile(FSSlaveDirectoryProvider.this.indexDir.resolve("current" + index), new FileAttribute[0]);
                }
                catch (IOException e) {
                    log.unableToCreateCurrentMarker(FSSlaveDirectoryProvider.this.indexDir.toString(), e);
                }
            }
            finally {
                this.inProgress.set(false);
            }
        }

        private Path determineCurrentSourceFile() {
            Path sourceFile = null;
            if (Files.exists(this.source.resolve("current1"), new LinkOption[0])) {
                sourceFile = this.source.resolve("1");
            } else if (Files.exists(this.source.resolve("current2"), new LinkOption[0])) {
                sourceFile = this.source.resolve("2");
            }
            return sourceFile;
        }
    }

    class UpdateTask
    extends TimerTask {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final CopyDirectory copyTask;

        public UpdateTask(Path sourceIndexDir, Path indexDir) {
            this.copyTask = new CopyDirectory(sourceIndexDir, indexDir);
        }

        @Override
        public void run() {
            if (this.copyTask.inProgress.compareAndSet(false, true)) {
                this.executor.execute(this.copyTask);
            } else if (log.isTraceEnabled()) {
                int unneeded = FSSlaveDirectoryProvider.this.current;
                log.tracef("Skipping directory synchronization, previous work still in progress: %s", FSSlaveDirectoryProvider.this.indexDir);
            }
        }

        public void stop() {
            this.executor.shutdownNow();
        }
    }

    class InitTask
    extends TimerTask {
        InitTask() {
        }

        @Override
        public void run() {
            try {
                if (FSSlaveDirectoryProvider.this.attemptInitializeAndStart()) {
                    this.cancel();
                }
            }
            catch (RuntimeException re) {
                log.failedSlaveDirectoryProviderInitialization(FSSlaveDirectoryProvider.this.indexDir.toString(), re);
            }
        }
    }
}

