/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ee.metadata.ClassAnnotationInformationFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.WebContextAnnotationInformationFactory;
import org.jboss.as.webservices.deployers.WebServiceAnnotationInformationFactory;
import org.jboss.as.webservices.deployers.WebServiceProviderAnnotationInformationFactory;
import org.jboss.metadata.property.PropertyReplacers;

public class WebServiceAnnotationProcessor
implements DeploymentUnitProcessor {
    final List<ClassAnnotationInformationFactory> factories;

    public WebServiceAnnotationProcessor() {
        ArrayList<ClassAnnotationInformationFactory> factories = new ArrayList<ClassAnnotationInformationFactory>();
        factories.add(new WebServiceAnnotationInformationFactory());
        factories.add(new WebServiceProviderAnnotationInformationFactory());
        factories.add(new WebContextAnnotationInformationFactory());
        this.factories = Collections.unmodifiableList(factories);
    }

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null || eeModuleDescription == null) {
            return;
        }
        for (ClassAnnotationInformationFactory factory : this.factories) {
            Map data = factory.createAnnotationInformation(index, PropertyReplacers.noop());
            for (Map.Entry entry : data.entrySet()) {
                EEModuleClassDescription clazz = eeModuleDescription.addOrGetLocalClassDescription((String)entry.getKey());
                clazz.addAnnotationInformation((ClassAnnotationInformation)entry.getValue());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

