/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;

public class ChannelNodeFactory
implements JGroupsNodeFactory,
AutoCloseable {
    private final ConcurrentMap<Address, Node> nodes = new ConcurrentHashMap<Address, Node>();
    private final Channel channel;

    public ChannelNodeFactory(Channel channel) {
        this.channel = channel;
    }

    public Node createNode(Address key) {
        return this.nodes.computeIfAbsent(key, address -> {
            IpAddress ipAddress = (IpAddress)this.channel.down(new Event(87, address));
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            String name = this.channel.getName(address);
            if (name == null) {
                name = String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort());
            }
            return new AddressableNode((Address)address, name, socketAddress);
        });
    }

    @Override
    public void close() {
        this.nodes.clear();
    }

    @Override
    public void invalidate(Collection<Address> addresses) {
        if (!addresses.isEmpty()) {
            this.nodes.keySet().removeAll(addresses);
        }
    }
}

