/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Compresses messages to send and uncompresses received messages")
public class COMPRESS
extends Protocol {
    @Property(description="Compression level (from java.util.zip.Deflater) (0=no compression, 1=best speed, 9=best compression). Default is 9")
    protected int compression_level = 9;
    @Property(description="Minimal payload size of a message (in bytes) for compression to kick in. Default is 500 bytes")
    protected long min_size = 500L;
    @Property(description="Number of inflaters/deflaters for concurrent processing. Default is 2 ")
    protected int pool_size = 2;
    protected BlockingQueue<Deflater> deflater_pool = null;
    protected BlockingQueue<Inflater> inflater_pool = null;

    @Override
    public void init() throws Exception {
        int i;
        this.deflater_pool = new ArrayBlockingQueue<Deflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.deflater_pool.add(new Deflater(this.compression_level));
        }
        this.inflater_pool = new ArrayBlockingQueue<Inflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.inflater_pool.add(new Inflater());
        }
    }

    @Override
    public void destroy() {
        for (Deflater deflater : this.deflater_pool) {
            deflater.end();
        }
        for (Inflater inflater : this.inflater_pool) {
            inflater.end();
        }
    }

    @Override
    public Object down(Event evt) {
        Message msg;
        int length;
        if (evt.getType() == 1 && (long)(length = (msg = (Message)evt.getArg()).getLength()) >= this.min_size) {
            byte[] payload = msg.getRawBuffer();
            byte[] compressed_payload = new byte[length];
            Deflater deflater = null;
            try {
                deflater = this.deflater_pool.take();
                deflater.reset();
                deflater.setInput(payload, msg.getOffset(), length);
                deflater.finish();
                deflater.deflate(compressed_payload);
                int compressed_size = deflater.getTotalOut();
                if (compressed_size < length) {
                    Message copy = msg.copy(false).putHeader(this.id, new CompressHeader(length)).setBuffer(compressed_payload, 0, compressed_size);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("down(): compressed payload from " + length + " bytes to " + compressed_size + " bytes");
                    }
                    Object object = this.down_prot.down(new Event(1, copy));
                    return object;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("down(): skipping compression since the compressed message (" + compressed_size + ") is not smaller than the original (" + length + ")");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                if (deflater != null) {
                    this.deflater_pool.offer(deflater);
                }
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        Message uncompressed_msg;
        Message msg;
        CompressHeader hdr;
        if (evt.getType() == 1 && (hdr = (CompressHeader)(msg = (Message)evt.getArg()).getHeader(this.id)) != null && (uncompressed_msg = this.uncompress(msg, hdr.original_size)) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("up(): uncompressed " + msg.getLength() + " bytes to " + uncompressed_msg.getLength() + " bytes");
            }
            return this.up_prot.up(new Event(1, uncompressed_msg));
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            Message uncompressed_msg;
            CompressHeader hdr = (CompressHeader)msg.getHeader(this.id);
            if (hdr == null || (uncompressed_msg = this.uncompress(msg, hdr.original_size)) == null) continue;
            if (this.log.isTraceEnabled()) {
                this.log.trace("up(): uncompressed " + msg.getLength() + " bytes to " + uncompressed_msg.getLength() + " bytes");
            }
            batch.replace(msg, uncompressed_msg);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message uncompress(Message msg, int original_size) {
        block10: {
            byte[] compressed_payload = msg.getRawBuffer();
            if (compressed_payload != null && compressed_payload.length > 0) {
                byte[] uncompressed_payload = new byte[original_size];
                Inflater inflater = null;
                try {
                    inflater = this.inflater_pool.take();
                    inflater.reset();
                    inflater.setInput(compressed_payload, msg.getOffset(), msg.getLength());
                    try {
                        inflater.inflate(uncompressed_payload);
                        Message message = msg.copy(false).setBuffer(uncompressed_payload);
                        return message;
                    }
                    catch (DataFormatException e) {
                        try {
                            this.log.error(Util.getMessage("CompressionFailure"), e);
                            if (inflater == null) break block10;
                            this.inflater_pool.offer(inflater);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (inflater != null) {
                        this.inflater_pool.offer(inflater);
                    }
                }
            }
        }
        return null;
    }

    public static class CompressHeader
    extends Header {
        int original_size = 0;

        public CompressHeader() {
        }

        public CompressHeader(int s) {
            this.original_size = s;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeInt(this.original_size);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.original_size = in.readInt();
        }
    }
}

