/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.invocationmetrics;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class InvocationMetrics {
    private final AtomicReference<Values> values = new AtomicReference<Values>(new Values(0L, 0L, 0L));
    private final AtomicLong concurrent = new AtomicLong(0L);
    private final AtomicLong peakConcurrent = new AtomicLong(0L);
    private final ConcurrentMap<String, AtomicReference<Values>> methods = new ConcurrentHashMap<String, AtomicReference<Values>>();

    void finishInvocation(Method method, long invocationWaitTime, long invocationExecutionTime) {
        Values newv;
        Values oldv;
        Values newv2;
        Values oldv2;
        this.concurrent.decrementAndGet();
        while (!this.values.compareAndSet(oldv2 = this.values.get(), newv2 = new Values(oldv2.invocations + 1L, oldv2.waitTime + invocationWaitTime, oldv2.executionTime + invocationExecutionTime))) {
        }
        AtomicReference<Values> methodValues = InvocationMetrics.ref(this.methods, method.getName());
        while (!methodValues.compareAndSet(oldv = methodValues.get(), newv = new Values(oldv.invocations + 1L, oldv.waitTime + invocationWaitTime, oldv.executionTime + invocationExecutionTime))) {
        }
    }

    private static AtomicReference<Values> ref(ConcurrentMap<String, AtomicReference<Values>> map, String key) {
        AtomicReference<Values> prevRef;
        AtomicReference<Values> ref = (AtomicReference<Values>)map.get(key);
        if (ref == null && (prevRef = map.putIfAbsent(key, ref = new AtomicReference<Values>(new Values(0L, 0L, 0L)))) != null) {
            ref = prevRef;
        }
        return ref;
    }

    public long getConcurrent() {
        return this.concurrent.get();
    }

    public long getExecutionTime() {
        return this.values.get().executionTime;
    }

    public long getInvocations() {
        return this.values.get().invocations;
    }

    public Map<String, Values> getMethods() {
        return new AbstractMap<String, Values>(){

            @Override
            public Set<Map.Entry<String, Values>> entrySet() {
                return new AbstractSet<Map.Entry<String, Values>>(){

                    @Override
                    public Iterator<Map.Entry<String, Values>> iterator() {
                        final Iterator delegate = InvocationMetrics.this.methods.entrySet().iterator();
                        return new Iterator<Map.Entry<String, Values>>(){

                            @Override
                            public boolean hasNext() {
                                return delegate.hasNext();
                            }

                            @Override
                            public Map.Entry<String, Values> next() {
                                final Map.Entry next = (Map.Entry)delegate.next();
                                return new Map.Entry<String, Values>(){

                                    @Override
                                    public String getKey() {
                                        return (String)next.getKey();
                                    }

                                    @Override
                                    public Values getValue() {
                                        return (Values)((AtomicReference)next.getValue()).get();
                                    }

                                    @Override
                                    public Values setValue(Values value) {
                                        throw new UnsupportedOperationException("NYI");
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("NYI");
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return InvocationMetrics.this.methods.size();
                    }
                };
            }
        };
    }

    public long getPeakConcurrent() {
        return this.peakConcurrent.get();
    }

    public long getWaitTime() {
        return this.values.get().waitTime;
    }

    void startInvocation() {
        long v = this.concurrent.incrementAndGet();
        if (this.peakConcurrent.get() < v) {
            this.peakConcurrent.incrementAndGet();
        }
    }

    public static class Values {
        final long invocations;
        final long executionTime;
        final long waitTime;

        private Values(long invocations, long waitTime, long executionTime) {
            this.invocations = invocations;
            this.executionTime = executionTime;
            this.waitTime = waitTime;
        }

        public long getExecutionTime() {
            return this.executionTime;
        }

        public long getInvocations() {
            return this.invocations;
        }

        public long getWaitTime() {
            return this.waitTime;
        }
    }
}

