/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractNamedFactoryExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class ConverterFactoryExtensionProcessor
extends AbstractNamedFactoryExtensionProcessor<CacheEventConverterFactory> {
    public ConverterFactoryExtensionProcessor(ServiceName extensionManagerServiceName) {
        super(extensionManagerServiceName);
    }

    @Override
    public AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventConverterFactory> createService(String name, CacheEventConverterFactory instance) {
        return new ConverterFactoryService(name, instance);
    }

    @Override
    public Class<CacheEventConverterFactory> getServiceClass() {
        return CacheEventConverterFactory.class;
    }

    private static final class ConverterFactoryService
    extends AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventConverterFactory> {
        private ConverterFactoryService(String name, CacheEventConverterFactory converterFactory) {
            super(name, converterFactory);
        }

        public void start(StartContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Started converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).addConverterFactory(this.name, (CacheEventConverterFactory)this.extension);
        }

        public void stop(StopContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Stopped converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).removeConverterFactory(this.name);
        }

        public CacheEventConverterFactory getValue() {
            return (CacheEventConverterFactory)this.extension;
        }

        @Override
        public String getServiceTypeName() {
            return "converter-factory";
        }
    }
}

