/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.core.transport.ExtendedByteBufJava;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ClientListenerRequestContext;
import org.infinispan.server.hotrod.Constants;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.ErrorResponse;
import org.infinispan.server.hotrod.ExecRequestContext;
import org.infinispan.server.hotrod.GetResponse;
import org.infinispan.server.hotrod.GetWithVersionResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodUnknownOperationException;
import org.infinispan.server.hotrod.IterationStartRequest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ResponseWithPrevious;
import org.infinispan.server.hotrod.StatsResponse;
import org.infinispan.server.hotrod.TimeUnitValue;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.TimeoutException;
import org.jgroups.SuspectedException;

class Decoder2x
implements VersionedDecoder {
    private static final Log log = (Log)LogFactory.getLog(Decoder2x.class, Log.class);
    private static final long EXPIRATION_NONE = -1L;
    private static final long EXPIRATION_DEFAULT = -2L;
    private static final CacheDecodeContext.ExpirationParam DEFAULT_EXPIRATION = new CacheDecodeContext.ExpirationParam(-1L, TimeUnitValue.SECONDS);

    Decoder2x() {
    }

    @Override
    public boolean readHeader(ByteBuf buffer, byte version, long messageId, HotRodHeader header) throws Exception {
        int flag;
        if (header.op == null) {
            int readableBytes = buffer.readableBytes();
            if (readableBytes < 2) {
                buffer.resetReaderIndex();
                return false;
            }
            byte streamOp = buffer.readByte();
            int length = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (length == Integer.MIN_VALUE || length > buffer.readableBytes()) {
                buffer.resetReaderIndex();
                return false;
            }
            if (length == 0) {
                header.cacheName = "";
            } else {
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                header.cacheName = new String(bytes, CharsetUtil.UTF_8);
            }
            header.op = HotRodOperation.fromRequestOpCode(streamOp);
            if (header.op == null) {
                throw new HotRodUnknownOperationException("Unknown operation: " + streamOp, version, messageId);
            }
            buffer.markReaderIndex();
        }
        if ((flag = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer)) == Integer.MIN_VALUE) {
            return false;
        }
        if (buffer.readableBytes() < 2) {
            buffer.resetReaderIndex();
            return false;
        }
        byte clientIntelligence = buffer.readByte();
        int topologyId = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
        if (topologyId == Integer.MIN_VALUE) {
            return false;
        }
        header.flag = flag;
        header.clientIntel = clientIntelligence;
        header.topologyId = topologyId;
        buffer.markReaderIndex();
        return true;
    }

    @Override
    public CacheDecodeContext.RequestParameters readParameters(HotRodHeader header, ByteBuf buffer) {
        switch (header.op) {
            case REMOVE_IF_UNMODIFIED: {
                return Decoder2x.readParameters(buffer, header, false, false, true);
            }
            case REPLACE_IF_UNMODIFIED: {
                return Decoder2x.readParameters(buffer, header, true, true, true);
            }
            case GET_ALL: {
                return Decoder2x.readParameters(buffer, header, false, true, false);
            }
            case PUT_STREAM: {
                return Decoder2x.readParameters(buffer, header, true, false, true);
            }
        }
        return Decoder2x.readParameters(buffer, header, true, true, false);
    }

    private static CacheDecodeContext.RequestParameters readParameters(ByteBuf buffer, HotRodHeader header, boolean readExpiration, boolean readSize, boolean readVersion) {
        int size;
        long version;
        CacheDecodeContext.ExpirationParam param2;
        CacheDecodeContext.ExpirationParam param1;
        if (readExpiration) {
            byte firstUnit;
            byte secondUnit;
            boolean pre22Version = Constants.isVersionPre22(header.version);
            if (pre22Version) {
                firstUnit = secondUnit = TimeUnitValue.SECONDS.getCode();
            } else {
                if (buffer.readableBytes() == 0) {
                    return null;
                }
                byte units = buffer.readByte();
                firstUnit = (byte)((units & 0xF0) >> 4);
                secondUnit = (byte)(units & 0xF);
            }
            param1 = Decoder2x.readExpirationParam(pre22Version, Decoder2x.hasFlag(header, ProtocolFlag.DefaultLifespan), buffer, firstUnit);
            if (param1 == null) {
                return null;
            }
            param2 = Decoder2x.readExpirationParam(pre22Version, Decoder2x.hasFlag(header, ProtocolFlag.DefaultMaxIdle), buffer, secondUnit);
            if (param2 == null) {
                return null;
            }
        } else {
            param1 = param2 = DEFAULT_EXPIRATION;
        }
        if (readVersion) {
            version = ExtendedByteBufJava.readUnsignedMaybeLong((ByteBuf)buffer);
            if (version == Long.MIN_VALUE) {
                return null;
            }
        } else {
            version = -1L;
        }
        if (readSize) {
            size = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (size == Integer.MIN_VALUE) {
                return null;
            }
        } else {
            size = -1;
        }
        buffer.markReaderIndex();
        return new CacheDecodeContext.RequestParameters(size, param1, param2, version);
    }

    private static CacheDecodeContext.ExpirationParam readExpirationParam(boolean pre22Version, boolean useDefault, ByteBuf buffer, byte timeUnit) {
        if (pre22Version) {
            int duration = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
            if (duration == Integer.MIN_VALUE) {
                return null;
            }
            if (duration <= 0) {
                duration = useDefault ? -2 : -1;
            }
            return new CacheDecodeContext.ExpirationParam(duration, TimeUnitValue.decode(timeUnit));
        }
        switch (timeUnit) {
            case 7: {
                return new CacheDecodeContext.ExpirationParam(-2L, TimeUnitValue.decode(timeUnit));
            }
            case 8: {
                return new CacheDecodeContext.ExpirationParam(-1L, TimeUnitValue.decode(timeUnit));
            }
        }
        long timeDuration = ExtendedByteBufJava.readMaybeVLong((ByteBuf)buffer);
        if (timeDuration == Long.MIN_VALUE) {
            return null;
        }
        return new CacheDecodeContext.ExpirationParam(timeDuration, TimeUnitValue.decode(timeUnit));
    }

    private static boolean hasFlag(HotRodHeader h, ProtocolFlag f) {
        return (h.flag & f.getValue()) == f.getValue();
    }

    @Override
    public Response createSuccessResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationStatus.Success, prev);
    }

    @Override
    public Response createNotExecutedResponse(HotRodHeader header, byte[] prev) {
        return this.createResponse(header, OperationStatus.OperationNotExecuted, prev);
    }

    @Override
    public Response createNotExistResponse(HotRodHeader header) {
        return this.createResponse(header, OperationStatus.KeyDoesNotExist, null);
    }

    private Response createResponse(HotRodHeader h, OperationStatus st, byte[] prev) {
        if (Decoder2x.hasFlag(h, ProtocolFlag.ForceReturnPreviousValue)) {
            switch (st) {
                case Success: {
                    switch (h.op) {
                        case REMOVE_IF_UNMODIFIED: 
                        case REPLACE_IF_UNMODIFIED: 
                        case PUT: 
                        case REPLACE: 
                        case REMOVE: {
                            return new ResponseWithPrevious(h.version, h.messageId, h.cacheName, h.clientIntel, h.op, OperationStatus.SuccessWithPrevious, h.topologyId, Optional.ofNullable(prev));
                        }
                    }
                    break;
                }
                case OperationNotExecuted: {
                    switch (h.op) {
                        case REMOVE_IF_UNMODIFIED: 
                        case REPLACE_IF_UNMODIFIED: 
                        case PUT_IF_ABSENT: {
                            return new ResponseWithPrevious(h.version, h.messageId, h.cacheName, h.clientIntel, h.op, OperationStatus.NotExecutedWithPrevious, h.topologyId, Optional.ofNullable(prev));
                        }
                    }
                }
            }
        }
        return new EmptyResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.op, st, h.topologyId);
    }

    @Override
    public Response createGetResponse(HotRodHeader h, CacheEntry<byte[], byte[]> entry) {
        HotRodOperation op = h.op;
        if (entry != null) {
            switch (op) {
                case GET: {
                    return new GetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.GET, OperationStatus.Success, h.topologyId, (byte[])entry.getValue());
                }
                case GET_WITH_VERSION: {
                    NumericVersion numericVersion = (NumericVersion)entry.getMetadata().version();
                    long version = numericVersion != null ? numericVersion.getVersion() : 0L;
                    return new GetWithVersionResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.GET_WITH_VERSION, OperationStatus.Success, h.topologyId, (byte[])entry.getValue(), version);
                }
            }
        } else {
            switch (op) {
                case GET: {
                    return new GetResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.GET, OperationStatus.KeyDoesNotExist, h.topologyId, null);
                }
                case GET_WITH_VERSION: {
                    return new GetWithVersionResponse(h.version, h.messageId, h.cacheName, h.clientIntel, HotRodOperation.GET_WITH_VERSION, OperationStatus.KeyDoesNotExist, h.topologyId, null, 0L);
                }
            }
        }
        throw new IllegalStateException("Unreachable code");
    }

    @Override
    public void customReadHeader(HotRodHeader header, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
        switch (header.op) {
            case AUTH: {
                ExtendedByteBuf.readMaybeString(buffer).flatMap(mech -> ExtendedByteBuf.readMaybeRangedBytes(buffer).map(clientResponse -> {
                    hrCtx.operationDecodeContext = new KeyValuePair(mech, clientResponse);
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                    return null;
                }));
                break;
            }
            case EXEC: {
                ExecRequestContext execCtx = (ExecRequestContext)hrCtx.operationDecodeContext;
                if (execCtx == null) {
                    Optional optional = ExtendedByteBuf.readMaybeString(buffer).flatMap(name -> ExtendedByteBuf.readMaybeVInt(buffer).map(paramCount -> {
                        ExecRequestContext ctx = new ExecRequestContext((String)name, (int)paramCount, (Map<String, byte[]>)new HashMap<String, byte[]>((int)paramCount));
                        hrCtx.operationDecodeContext = ctx;
                        buffer.markReaderIndex();
                        return ctx;
                    }));
                    if (optional.isPresent()) {
                        execCtx = (ExecRequestContext)optional.get();
                    } else {
                        return;
                    }
                }
                if (execCtx.getParamSize() == 0) {
                    out.add(hrCtx);
                    break;
                }
                Map map = execCtx.getParams();
                boolean readAll = true;
                while (map.size() < execCtx.getParamSize()) {
                    if (ExtendedByteBuf.readMaybeString(buffer).flatMap(key -> ExtendedByteBuf.readMaybeRangedBytes(buffer).map(value -> {
                        map.put((String)key, value);
                        buffer.markReaderIndex();
                        return value;
                    })).isPresent()) continue;
                    readAll = false;
                    break;
                }
                if (!readAll) break;
                out.add(hrCtx);
                break;
            }
            default: {
                out.add(hrCtx);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void customReadKey(HotRodHeader header, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
        switch (header.op) {
            case BULK_GET: 
            case BULK_GET_KEYS: {
                ExtendedByteBuf.readMaybeVInt(buffer).ifPresent(number -> {
                    hrCtx.operationDecodeContext = number;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
                return;
            }
            case QUERY: {
                ExtendedByteBuf.readMaybeRangedBytes(buffer).ifPresent(query -> {
                    hrCtx.operationDecodeContext = query;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
                return;
            }
            case GET_STREAM: {
                ExtendedByteBuf.readMaybeVInt(buffer).ifPresent(offset -> {
                    hrCtx.operationDecodeContext = offset;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
                return;
            }
            case ADD_CLIENT_LISTENER: {
                ClientListenerRequestContext requestCtx;
                if (hrCtx.operationDecodeContext == null) {
                    Optional optional = ExtendedByteBuf.readMaybeRangedBytes(buffer).flatMap(listenerId -> ExtendedByteBuf.readMaybeByte(buffer).map(includeState -> {
                        ClientListenerRequestContext ctx = new ClientListenerRequestContext((byte[])listenerId, includeState == 1);
                        hrCtx.operationDecodeContext = ctx;
                        buffer.markReaderIndex();
                        return ctx;
                    }));
                    if (!optional.isPresent()) return;
                    requestCtx = (ClientListenerRequestContext)optional.get();
                } else {
                    requestCtx = (ClientListenerRequestContext)hrCtx.operationDecodeContext;
                }
                if (requestCtx.getFilterFactoryInfo() == null && !this.readMaybeNamedFactory(buffer).map(f -> {
                    requestCtx.setFilterFactoryInfo((Optional<KeyValuePair<String, List<byte[]>>>)f);
                    buffer.markReaderIndex();
                    return requestCtx;
                }).isPresent()) {
                    return;
                }
                if (requestCtx.getConverterFactoryInfo() == null && !this.readMaybeNamedFactory(buffer).map(converter -> {
                    boolean useRawData;
                    if (Constants.isVersion2x(header.version)) {
                        Optional<Byte> rawOptional = ExtendedByteBuf.readMaybeByte(buffer);
                        if (!rawOptional.isPresent()) return null;
                        useRawData = rawOptional.get() == 1;
                    } else {
                        useRawData = false;
                    }
                    requestCtx.setConverterFactoryInfo((Optional<KeyValuePair<String, List<byte[]>>>)converter);
                    requestCtx.setUseRawData(useRawData);
                    buffer.markReaderIndex();
                    return requestCtx;
                }).isPresent()) {
                    return;
                }
                if (Constants.isVersionPost25(header.version)) {
                    int listenerInterests = ExtendedByteBufJava.readMaybeVInt((ByteBuf)buffer);
                    if (listenerInterests == Integer.MIN_VALUE) {
                        return;
                    }
                    requestCtx.setListenerInterests(listenerInterests);
                    buffer.markReaderIndex();
                }
                out.add(hrCtx);
                return;
            }
            case REMOVE_CLIENT_LISTENER: {
                ExtendedByteBuf.readMaybeRangedBytes(buffer).ifPresent(listenerId -> {
                    hrCtx.operationDecodeContext = listenerId;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
                return;
            }
            case ITERATION_START: {
                ExtendedByteBuf.readMaybeOptRangedBytes(buffer).flatMap(segments -> ExtendedByteBuf.readMaybeOptString(buffer).map(name -> {
                    boolean metadata;
                    Optional<KeyValuePair<String, List<byte[]>>> factory;
                    boolean isPre24 = Constants.isVersionPre24(header.version);
                    if (name.isPresent()) {
                        if (isPre24) {
                            factory = Optional.of(new KeyValuePair(name.get(), Collections.emptyList()));
                        } else {
                            Optional<List<byte[]>> optionalParams = this.readOptionalParams(buffer);
                            if (!optionalParams.isPresent()) return null;
                            factory = Optional.of(new KeyValuePair(name.get(), optionalParams.get()));
                        }
                    } else {
                        factory = Optional.empty();
                    }
                    Optional<Integer> optionalBatchSize = ExtendedByteBuf.readMaybeVInt(buffer);
                    if (!optionalBatchSize.isPresent()) {
                        return null;
                    }
                    int batchSize = optionalBatchSize.get();
                    if (isPre24) {
                        metadata = false;
                    } else {
                        Optional<Byte> optionalMetadata = ExtendedByteBuf.readMaybeByte(buffer);
                        if (!optionalMetadata.isPresent()) return null;
                        metadata = optionalMetadata.get() != 0;
                    }
                    hrCtx.operationDecodeContext = new IterationStartRequest((Optional<byte[]>)segments, factory, batchSize, metadata);
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                    return null;
                }));
                return;
            }
            case ITERATION_NEXT: 
            case ITERATION_END: {
                ExtendedByteBuf.readMaybeString(buffer).ifPresent(iterationId -> {
                    hrCtx.operationDecodeContext = iterationId;
                    buffer.markReaderIndex();
                    out.add(hrCtx);
                });
            }
        }
    }

    private Optional<Optional<KeyValuePair<String, List<byte[]>>>> readMaybeNamedFactory(ByteBuf buffer) {
        return ExtendedByteBuf.readMaybeString(buffer).flatMap(name -> {
            if (!name.isEmpty()) {
                return this.readOptionalParams(buffer).map(param -> Optional.of(new KeyValuePair(name, param)));
            }
            return Optional.of(Optional.empty());
        });
    }

    private Optional<List<byte[]>> readOptionalParams(ByteBuf buffer) {
        Optional<Byte> numParams = ExtendedByteBuf.readMaybeByte(buffer);
        return numParams.map(p -> {
            if (p > 0) {
                ArrayList params = new ArrayList();
                boolean readAll = true;
                while (params.size() < p) {
                    if (ExtendedByteBuf.readMaybeRangedBytes(buffer).map(param -> {
                        params.add(param);
                        return param;
                    }).isPresent()) continue;
                    readAll = false;
                    break;
                }
                if (readAll) {
                    return Optional.of(params);
                }
                return null;
            }
            return Optional.of(Collections.emptyList());
        }).orElse(Optional.empty());
    }

    @Override
    public void customReadValue(HotRodHeader header, ByteBuf buffer, CacheDecodeContext hrCtx, List<Object> out) {
        switch (header.op) {
            case PUT_ALL: {
                HashMap map;
                int maxLength = hrCtx.params.valueLength;
                if (hrCtx.operationDecodeContext == null) {
                    hrCtx.operationDecodeContext = map = new HashMap(maxLength);
                } else {
                    map = (HashMap)hrCtx.operationDecodeContext;
                }
                boolean readAll = true;
                while (map.size() < maxLength) {
                    if (ExtendedByteBuf.readMaybeRangedBytes(buffer).flatMap(key -> ExtendedByteBuf.readMaybeRangedBytes(buffer).map(value -> {
                        map.put(key, value);
                        buffer.markReaderIndex();
                        return value;
                    })).isPresent()) continue;
                    readAll = false;
                    break;
                }
                if (!readAll) break;
                out.add(hrCtx);
                break;
            }
            case GET_ALL: {
                HashSet set;
                int maxLength = hrCtx.params.valueLength;
                if (hrCtx.operationDecodeContext == null) {
                    hrCtx.operationDecodeContext = set = new HashSet(maxLength);
                } else {
                    set = (HashSet)hrCtx.operationDecodeContext;
                }
                boolean readAll = true;
                while (set.size() < maxLength) {
                    if (ExtendedByteBuf.readMaybeRangedBytes(buffer).map(bytes -> {
                        set.add(bytes);
                        buffer.markReaderIndex();
                        return bytes;
                    }).isPresent()) continue;
                    readAll = false;
                    break;
                }
                if (!readAll) break;
                out.add(hrCtx);
                break;
            }
            case PUT_STREAM: {
                ByteBuf vBuffer;
                if (hrCtx.operationDecodeContext == null) {
                    vBuffer = ByteBufAllocator.DEFAULT.buffer();
                    hrCtx.operationDecodeContext = vBuffer;
                } else {
                    vBuffer = (ByteBuf)hrCtx.operationDecodeContext;
                }
                if (vBuffer == null) break;
                ExtendedByteBuf.readMaybeRangedBytes(buffer).map(bytes -> {
                    if (((byte[])bytes).length > 0) {
                        vBuffer.writeBytes(bytes);
                    } else {
                        out.add(hrCtx);
                    }
                    buffer.markReaderIndex();
                    return Optional.empty();
                });
            }
        }
    }

    @Override
    public StatsResponse createStatsResponse(CacheDecodeContext ctx, NettyTransport t) {
        ComponentRegistry registry;
        ClusterCacheStats clusterCacheStats;
        Stats cacheStats = ctx.cache.getStats();
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("timeSinceStart", String.valueOf(cacheStats.getTimeSinceStart()));
        stats.put("currentNumberOfEntries", String.valueOf(cacheStats.getCurrentNumberOfEntries()));
        stats.put("totalNumberOfEntries", String.valueOf(cacheStats.getTotalNumberOfEntries()));
        stats.put("stores", String.valueOf(cacheStats.getStores()));
        stats.put("retrievals", String.valueOf(cacheStats.getRetrievals()));
        stats.put("hits", String.valueOf(cacheStats.getHits()));
        stats.put("misses", String.valueOf(cacheStats.getMisses()));
        stats.put("removeHits", String.valueOf(cacheStats.getRemoveHits()));
        stats.put("removeMisses", String.valueOf(cacheStats.getRemoveMisses()));
        stats.put("totalBytesRead", t.getTotalBytesRead());
        stats.put("totalBytesWritten", t.getTotalBytesWritten());
        HotRodHeader h = ctx.header;
        if (!Constants.isVersionPre24(h.version) && (clusterCacheStats = (ClusterCacheStats)(registry = ctx.getCacheRegistry(h.cacheName)).getComponent(ClusterCacheStats.class)) != null) {
            stats.put("globalCurrentNumberOfEntries", String.valueOf(clusterCacheStats.getCurrentNumberOfEntries()));
            stats.put("globalStores", String.valueOf(clusterCacheStats.getStores()));
            stats.put("globalRetrievals", String.valueOf(clusterCacheStats.getRetrievals()));
            stats.put("globalHits", String.valueOf(clusterCacheStats.getHits()));
            stats.put("globalMisses", String.valueOf(clusterCacheStats.getMisses()));
            stats.put("globalRemoveHits", String.valueOf(clusterCacheStats.getRemoveHits()));
            stats.put("globalRemoveMisses", String.valueOf(clusterCacheStats.getRemoveMisses()));
        }
        return new StatsResponse(h.version, h.messageId, h.cacheName, h.clientIntel, stats, h.topologyId);
    }

    @Override
    public ErrorResponse createErrorResponse(HotRodHeader h, Throwable t) {
        if (t instanceof SuspectException) {
            return this.createNodeSuspectedErrorResponse(h, t);
        }
        if (t instanceof IllegalLifecycleStateException) {
            return this.createIllegalLifecycleStateErrorResponse(h, t);
        }
        if (t instanceof IOException) {
            return new ErrorResponse(h.version, h.messageId, h.cacheName, h.clientIntel, OperationStatus.ParseError, h.topologyId, t.toString());
        }
        if (t instanceof TimeoutException) {
            return new ErrorResponse(h.version, h.messageId, h.cacheName, h.clientIntel, OperationStatus.OperationTimedOut, h.topologyId, t.toString());
        }
        if (t instanceof CacheException) {
            Throwable cause;
            Throwable throwable = cause = t.getCause() == null ? t : t.getCause();
            if (cause instanceof SuspectedException) {
                return this.createNodeSuspectedErrorResponse(h, cause);
            }
            if (cause instanceof IllegalLifecycleStateException) {
                return this.createIllegalLifecycleStateErrorResponse(h, cause);
            }
            if (cause instanceof InterruptedException) {
                return this.createIllegalLifecycleStateErrorResponse(h, cause);
            }
            return this.createServerErrorResponse(h, cause);
        }
        if (t instanceof InterruptedException) {
            return this.createIllegalLifecycleStateErrorResponse(h, t);
        }
        if (t instanceof PrivilegedActionException) {
            return this.createErrorResponse(h, t.getCause());
        }
        return this.createServerErrorResponse(h, t);
    }

    private ErrorResponse createNodeSuspectedErrorResponse(HotRodHeader h, Throwable t) {
        return new ErrorResponse(h.version, h.messageId, h.cacheName, h.clientIntel, OperationStatus.NodeSuspected, h.topologyId, t.toString());
    }

    private ErrorResponse createIllegalLifecycleStateErrorResponse(HotRodHeader h, Throwable t) {
        return new ErrorResponse(h.version, h.messageId, h.cacheName, h.clientIntel, OperationStatus.IllegalLifecycleState, h.topologyId, t.toString());
    }

    private ErrorResponse createServerErrorResponse(HotRodHeader h, Throwable t) {
        return new ErrorResponse(h.version, h.messageId, h.cacheName, h.clientIntel, OperationStatus.ServerError, h.topologyId, this.createErrorMsg(t));
    }

    String createErrorMsg(Throwable t) {
        LinkedHashSet<Throwable> causes = new LinkedHashSet<Throwable>();
        for (Throwable initial = t; initial != null && !causes.contains(initial); initial = initial.getCause()) {
            causes.add(initial);
        }
        return causes.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public AdvancedCache<byte[], byte[]> getOptimizedCache(HotRodHeader h, AdvancedCache<byte[], byte[]> c, Configuration cacheCfg) {
        boolean isTransactional = cacheCfg.transaction().transactionMode().isTransactional();
        boolean isClustered = cacheCfg.clustering().cacheMode().isClustered();
        AdvancedCache optCache = c;
        if (isClustered && !isTransactional && h.op.isConditional()) {
            log.warnConditionalOperationNonTransactional(h.op.toString());
        }
        if (h.op.canSkipCacheLoading() && Decoder2x.hasFlag(h, ProtocolFlag.SkipCacheLoader)) {
            optCache = c.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
        }
        if (h.op.canSkipIndexing() && Decoder2x.hasFlag(h, ProtocolFlag.SkipIndexing)) {
            optCache = c.withFlags(new Flag[]{Flag.SKIP_INDEXING});
        }
        if (!Decoder2x.hasFlag(h, ProtocolFlag.ForceReturnPreviousValue)) {
            if (h.op.isNotConditionalAndCanReturnPrevious()) {
                optCache = optCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
            }
        } else if (!isTransactional && h.op.canReturnPreviousValue()) {
            log.warnForceReturnPreviousNonTransactional(h.op.toString());
        }
        return optCache;
    }
}

