/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.iteration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.CompatibilityModeConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.iteration.CompatInfo;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.iteration.IterationFilter;
import org.infinispan.server.hotrod.iteration.IterationManager;
import org.infinispan.server.hotrod.iteration.IterationSegmentsListener;
import org.infinispan.server.hotrod.iteration.IterationState;
import org.infinispan.server.hotrod.iteration.MarshallerBuilder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.KeyValuePair;

public class DefaultIterationManager
implements IterationManager {
    private final EmbeddedCacheManager cacheManager;
    volatile Optional<Marshaller> marshaller = Optional.empty();
    static final Log log = (Log)LogFactory.getLog(DefaultIterationManager.class, Log.class);
    private final Map<String, IterationState> iterationStateMap = CollectionFactory.makeConcurrentMap();
    private final Map<String, KeyValueFilterConverterFactory> filterConverterFactoryMap = CollectionFactory.makeConcurrentMap();

    public DefaultIterationManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public String start(Cache cache, Optional<BitSet> segments, Optional<KeyValuePair<String, List<byte[]>>> namedFactory, int batch, boolean metadata) {
        Object filteredStream;
        String iterationId = UUID.randomUUID().toString();
        AdvancedCache advancedCache = cache.getAdvancedCache();
        CompatibilityModeConfiguration compatibilityConfig = advancedCache.getCacheConfiguration().compatibility();
        AdvancedCache iterationCache = compatibilityConfig.enabled() ? advancedCache.withEncoding(IdentityEncoder.class) : advancedCache;
        CacheStream stream = iterationCache.cacheEntrySet().stream();
        segments.map(bitSet -> stream.filterKeySegments(bitSet.stream().boxed().collect(Collectors.toSet())));
        IterationSegmentsListener segmentListener = new IterationSegmentsListener();
        CompatInfo compatInfo = CompatInfo.create(compatibilityConfig);
        if (namedFactory.isPresent()) {
            KeyValueFilterConverterFactory factory = this.getFactory((String)namedFactory.get().getKey());
            List params = (List)namedFactory.get().getValue();
            KeyValuePair<KeyValueFilterConverter, Boolean> filter = this.buildFilter(factory, (byte[][])params.toArray((T[])new byte[params.size()][]));
            IterationFilter iterationFilter = new IterationFilter(compatInfo.enabled, Optional.of(filter.getKey()), this.marshaller, (Boolean)filter.getValue());
            filteredStream = CacheFilters.filterAndConvert((Stream)stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener), iterationFilter);
        } else {
            filteredStream = stream.segmentCompletionListener((BaseCacheStream.SegmentCompletionListener)segmentListener);
        }
        IterationState iterationState = new IterationState(segmentListener, filteredStream.iterator(), (CacheStream<CacheEntry<Object, Object>>)stream, batch, compatInfo, metadata);
        this.iterationStateMap.put(iterationId, iterationState);
        return iterationId;
    }

    private KeyValueFilterConverterFactory getFactory(String name) {
        KeyValueFilterConverterFactory factory = this.filterConverterFactoryMap.get(name);
        if (factory == null) {
            throw log.missingKeyValueFilterConverterFactory(name);
        }
        return factory;
    }

    private KeyValuePair<KeyValueFilterConverter, Boolean> buildFilter(KeyValueFilterConverterFactory factory, byte[][] params) {
        if (factory instanceof ParamKeyValueFilterConverterFactory) {
            ParamKeyValueFilterConverterFactory paramFactory = (ParamKeyValueFilterConverterFactory)factory;
            Object unmarshallParams = paramFactory.binaryParam() ? params : (Object)this.unmarshallParams(params, factory);
            return new KeyValuePair((Object)paramFactory.getFilterConverter((Object[])unmarshallParams), (Object)paramFactory.binaryParam());
        }
        return new KeyValuePair((Object)factory.getFilterConverter(), (Object)false);
    }

    private Object[] unmarshallParams(byte[][] params, Object factory) {
        Marshaller m = this.marshaller.orElse(MarshallerBuilder.genericFromInstance(Optional.of(factory)));
        try {
            Object[] objectParams = new Object[params.length];
            int i = 0;
            for (byte[] param : params) {
                objectParams[i++] = m.objectFromByteBuffer(param);
            }
            return objectParams;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public IterableIterationResult next(String cacheName, String iterationId) {
        IterationState iterationState = this.iterationStateMap.get(iterationId);
        if (iterationState != null) {
            int i = 0;
            ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>(iterationState.batch);
            while (i++ < iterationState.batch && iterationState.iterator.hasNext()) {
                entries.add(iterationState.iterator.next());
            }
            return new IterableIterationResult(iterationState.listener.getFinished(entries.isEmpty()), OperationStatus.Success, entries, iterationState.compatInfo, iterationState.metadata);
        }
        return new IterableIterationResult(Collections.emptySet(), OperationStatus.InvalidIteration, Collections.emptyList(), null, false);
    }

    @Override
    public boolean close(String cacheName, String iterationId) {
        IterationState iterationState = this.iterationStateMap.get(iterationId);
        if (iterationState != null) {
            iterationState.stream.close();
            this.iterationStateMap.remove(iterationId);
            return true;
        }
        return false;
    }

    @Override
    public void addKeyValueFilterConverterFactory(String name, KeyValueFilterConverterFactory factory) {
        this.filterConverterFactoryMap.put(name, factory);
    }

    @Override
    public void removeKeyValueFilterConverterFactory(String name) {
        this.filterConverterFactoryMap.remove(name);
    }

    @Override
    public int activeIterations() {
        return this.iterationStateMap.size();
    }

    @Override
    public void setMarshaller(Optional<Marshaller> marshaller) {
        this.marshaller = marshaller;
    }
}

