/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.affinity;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.query.affinity.AffinityErrorHandler;
import org.infinispan.query.affinity.LuceneWorkDispatcher;
import org.infinispan.query.affinity.ShardAddress;
import org.infinispan.query.affinity.ShardAllocatorManager;
import org.infinispan.query.affinity.WorkPartitioner;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.TransactionHelper;
import org.infinispan.query.logging.Log;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.util.logging.LogFactory;

@Listener(observation=Listener.Observation.POST)
public class AffinityIndexManager
extends DirectoryBasedIndexManager {
    private static final Log log = (Log)LogFactory.getLog(AffinityIndexManager.class, Log.class);
    private static final long POLL_WAIT = 1000L;
    private KeyTransformationHandler keyTransformationHandler;
    private Cache<?, ?> cache;
    private final ReadWriteLock flushLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.flushLock.writeLock();
    private final Lock readLock = this.flushLock.readLock();
    private ShardAllocatorManager shardAllocatorManager;
    private TransactionHelper transactionHelper;
    private SearchIntegrator searchIntegrator;
    private String shardId;
    private boolean isAsync;
    private ShardAddress localShardAddress;
    private LuceneWorkDispatcher luceneWorkDispatcher;
    private WorkPartitioner workPartitioner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext buildContext) {
        ServiceManager serviceManager = buildContext.getServiceManager();
        ComponentRegistryService componentRegistryService = (ComponentRegistryService)serviceManager.requestService(ComponentRegistryService.class);
        ComponentRegistry componentRegistry = componentRegistryService.getComponentRegistry();
        this.transactionHelper = new TransactionHelper((TransactionManager)componentRegistry.getComponent(TransactionManager.class));
        this.shardId = this.extractShardName(indexName);
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            super.initialize(indexName, properties, similarity, buildContext);
        }
        finally {
            this.transactionHelper.resume(tx);
        }
        RpcManager rpcManager = (RpcManager)componentRegistry.getComponent(RpcManager.class);
        this.cache = (Cache)componentRegistry.getComponent(Cache.class);
        this.keyTransformationHandler = ((QueryInterceptor)((Object)componentRegistry.getComponent(QueryInterceptor.class))).getKeyTransformationHandler();
        this.shardAllocatorManager = (ShardAllocatorManager)componentRegistry.getComponent(ShardAllocatorManager.class);
        this.searchIntegrator = (SearchIntegrator)componentRegistry.getComponent(SearchIntegrator.class);
        this.isAsync = !BackendFactory.isConfiguredAsSync((Properties)properties);
        this.localShardAddress = new ShardAddress(this.shardId, rpcManager != null ? rpcManager.getAddress() : LocalModeAddress.INSTANCE);
        ExecutorService asyncExecutor = (ExecutorService)componentRegistry.getComponent(ExecutorService.class, "org.infinispan.executors.async");
        this.luceneWorkDispatcher = new LuceneWorkDispatcher(this, rpcManager);
        this.workPartitioner = new WorkPartitioner(this, this.shardAllocatorManager);
        AffinityErrorHandler errorHandler = (AffinityErrorHandler)this.searchIntegrator.getErrorHandler();
        errorHandler.initialize(rpcManager, asyncExecutor);
        this.cache.addListener((Object)this);
    }

    private void handleOwnershipLost() {
        this.writeLock.lock();
        try {
            log.debugf("Ownership of %s lost to '%s', closing index manager", this.getIndexName(), this.shardAllocatorManager.getOwner(String.valueOf(this.shardId)));
            this.flushAndReleaseResources();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void flushAndReleaseResources() {
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)this.getDirectoryProvider();
        int activeDeleteTasks = directoryProvider.pendingDeleteTasks();
        boolean wasInterrupted = false;
        long endTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(1000L);
        while (activeDeleteTasks > 0 && endTime - System.nanoTime() > 0L) {
            try {
                Thread.sleep(10L);
                log.debugf("Waiting for pending delete tasks, remaining: %s", activeDeleteTasks);
                activeDeleteTasks = directoryProvider.pendingDeleteTasks();
            }
            catch (InterruptedException ignored) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        log.debugf("Flushing directory provider at %s on %s", this.getIndexName(), this.localShardAddress);
        super.flushAndReleaseResources();
    }

    Object stringToKey(String key) {
        return this.keyTransformationHandler.stringToKey(key, this.cache.getAdvancedCache().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address getLockHolder(String indexName, String affinityId) {
        log.debugf("Getting lock holder for %s", indexName);
        Transaction tx = this.transactionHelper.suspendTxIfExists();
        try {
            InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)this.getDirectoryProvider();
            Address address = directoryProvider.getLockOwner(indexName, Integer.valueOf(affinityId).intValue(), "write.lock");
            return address;
        }
        finally {
            this.transactionHelper.resume(tx);
        }
    }

    Address getLockHolder() {
        return this.getLockHolder(this.getIndexName(), this.shardId);
    }

    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.performOperations(workList, monitor, true, false);
    }

    private void checkOwnership() {
        log.debugf("Checking ownership at %s", this.localShardAddress);
        Address primaryOwner = this.shardAllocatorManager.getOwner(this.shardId);
        if (!this.localShardAddress.getAddress().equals(primaryOwner)) {
            log.debugf("%s is not owner of %s anymore, releasing resources", this.localShardAddress, this.getIndexName());
            this.handleOwnershipLost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performOperations(List<LuceneWork> workList, IndexingMonitor monitor, boolean originLocal, boolean isRetry) {
        if (this.cache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
            Map<ShardAddress, List<LuceneWork>> workByAddress = this.workPartitioner.partitionWorkByAddress(workList, originLocal, isRetry);
            this.readLock.lock();
            try {
                log.debugf("Applying work @ %s, workMap is %s", this.localShardAddress, workByAddress);
                List<LuceneWork> localWork = workByAddress.get(this.localShardAddress);
                if (localWork != null && !localWork.isEmpty()) {
                    log.debugf("About to apply local work %s (index %s) at %s", localWork, this.getIndexName(), this.localShardAddress);
                    super.performOperations(localWork, monitor);
                    log.debugf("Work %s applied at %s", localWork, this.localShardAddress);
                    workByAddress.remove(this.localShardAddress);
                }
            }
            finally {
                this.readLock.unlock();
            }
            workByAddress.entrySet().forEach(entry -> this.luceneWorkDispatcher.dispatch((List)entry.getValue(), (ShardAddress)entry.getKey(), originLocal));
            if (isRetry || !originLocal) {
                this.checkOwnership();
            }
        } else {
            super.performOperations(workList, monitor);
        }
    }

    private String extractShardName(String indexName) {
        int idx = indexName.lastIndexOf(46);
        return idx == -1 ? "0" : indexName.substring(idx + 1);
    }

    protected DirectoryProvider<?> createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        InfinispanDirectoryProvider directoryProvider = new InfinispanDirectoryProvider(Integer.valueOf(this.shardId).intValue());
        directoryProvider.initialize(indexName, cfg, (BuildContext)buildContext);
        return directoryProvider;
    }

    ShardAddress getLocalShardAddress() {
        return this.localShardAddress;
    }

    KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    String getCacheName() {
        return this.cache.getName();
    }

    boolean isAsync() {
        return this.isAsync;
    }

    SearchIntegrator getSearchIntegrator() {
        return this.searchIntegrator;
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        log.debugf("Topology changed notification for %s: %s", this.getIndexName(), tce);
        boolean ownershipChanged = this.shardAllocatorManager.isOwnershipChanged(tce, this.getIndexName());
        log.debugf("Ownership changed? %s,", ownershipChanged);
        if (ownershipChanged) {
            this.handleOwnershipLost();
        }
    }
}

