/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.Locale;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexNameNormalizer {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);

    private ElasticsearchIndexNameNormalizer() {
    }

    public static URLEncodedString getElasticsearchIndexName(String indexName) {
        String esIndexName = indexName.toLowerCase(Locale.ENGLISH);
        if (!esIndexName.equals(indexName)) {
            LOG.debugf("Normalizing index name from '%1$s' to '%2$s'", indexName, esIndexName);
        }
        return URLEncodedString.fromString(esIndexName);
    }
}

