/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.search.elasticsearch.processor.impl.ContextualErrorHandler;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkExecutor;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.BulkResult;
import org.hibernate.search.elasticsearch.work.impl.BulkResultItemExtractor;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.Futures;

class DefaultElasticsearchWorkSequenceBuilder
implements ElasticsearchWorkSequenceBuilder {
    private final ElasticsearchWorkExecutor executor;
    private final Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier;
    private final Supplier<ContextualErrorHandler> errorHandlerSupplier;
    private final BulkResultExtractionStepImpl bulkResultExtractionStep = new BulkResultExtractionStepImpl();
    private CompletableFuture<Void> rootSequenceFuture;
    private CompletableFuture<?> sequenceFuture;
    private FlushableElasticsearchWorkExecutionContext executionContext;
    private ContextualErrorHandler errorHandler;

    public DefaultElasticsearchWorkSequenceBuilder(ElasticsearchWorkExecutor executor, Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplier, Supplier<ContextualErrorHandler> errorHandlerSupplier) {
        this.executor = executor;
        this.contextSupplier = contextSupplier;
        this.errorHandlerSupplier = errorHandlerSupplier;
    }

    @Override
    public void init(CompletableFuture<?> previous) {
        this.rootSequenceFuture = previous.handle((ignoredResult, ignoredThrowable) -> null);
        this.sequenceFuture = this.rootSequenceFuture;
        this.executionContext = this.contextSupplier.get();
        this.errorHandler = this.errorHandlerSupplier.get();
    }

    @Override
    public <T> void addNonBulkExecution(ElasticsearchWork<T> work) {
        FlushableElasticsearchWorkExecutionContext context = this.executionContext;
        this.sequenceFuture = this.chain(this.sequenceFuture, work, ignored -> this.executor.submit(work, context));
    }

    @Override
    public CompletableFuture<BulkResult> addBulkExecution(CompletableFuture<? extends ElasticsearchWork<BulkResult>> workFuture) {
        FlushableElasticsearchWorkExecutionContext context = this.executionContext;
        CompletionStage bulkWorkResultFuture = ((CompletableFuture)this.sequenceFuture.thenCombine(workFuture, (ignored, work) -> work)).thenCompose(work -> this.executor.submit(work, context));
        this.sequenceFuture = bulkWorkResultFuture;
        return bulkWorkResultFuture;
    }

    @Override
    public ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep startBulkResultExtraction(CompletableFuture<BulkResult> bulkResultFuture) {
        FlushableElasticsearchWorkExecutionContext context = this.executionContext;
        CompletionStage extractorFuture = bulkResultFuture.thenApply(bulkResult -> bulkResult.withContext(context));
        this.bulkResultExtractionStep.init((CompletableFuture<BulkResultItemExtractor>)extractorFuture);
        return this.bulkResultExtractionStep;
    }

    @Override
    public CompletableFuture<Void> build() {
        FlushableElasticsearchWorkExecutionContext context = this.executionContext;
        ContextualErrorHandler errorHandler = this.errorHandler;
        CompletionStage futureWithFlush = Futures.whenCompleteExecute(this.sequenceFuture, () -> context.flush()).exceptionally(Futures.handler(throwable -> {
            if (!(throwable instanceof PreviousWorkException)) {
                errorHandler.addThrowable((Throwable)throwable);
            }
            errorHandler.handle();
            return null;
        }));
        return futureWithFlush;
    }

    private <T, R> CompletableFuture<R> chain(CompletableFuture<T> previous, ElasticsearchWork<R> work, Function<T, CompletableFuture<R>> composer) {
        ContextualErrorHandler errorHandler = this.errorHandler;
        Function safeComposer = Futures.safeComposer(composer);
        return ((CompletableFuture)previous.whenComplete((result, throwable) -> {
            if (throwable != null) {
                errorHandler.markAsSkipped(work);
            }
        })).thenCompose(previousResult -> ((CompletionStage)safeComposer.apply(previousResult)).handle(Futures.handler((result, throwable) -> {
            if (throwable != null) {
                errorHandler.markAsFailed(work, (Throwable)throwable);
                throw new PreviousWorkException((Throwable)throwable);
            }
            return result;
        })));
    }

    private final class BulkResultExtractionStepImpl
    implements ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep {
        private CompletableFuture<BulkResultItemExtractor> extractorFuture;

        private BulkResultExtractionStepImpl() {
        }

        public void init(CompletableFuture<BulkResultItemExtractor> extractorFuture) {
            this.extractorFuture = extractorFuture;
        }

        @Override
        public <T> void add(BulkableElasticsearchWork<T> bulkedWork, int index) {
            CompletableFuture bulkedWorkResultFuture = DefaultElasticsearchWorkSequenceBuilder.this.chain(this.extractorFuture, bulkedWork, extractor -> extractor.extract(bulkedWork, index));
            DefaultElasticsearchWorkSequenceBuilder.this.sequenceFuture = CompletableFuture.allOf(DefaultElasticsearchWorkSequenceBuilder.this.sequenceFuture, bulkedWorkResultFuture);
        }
    }

    private static final class PreviousWorkException
    extends SearchException {
        public PreviousWorkException(Throwable cause) {
            super(cause);
        }
    }
}

