/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.processor.impl.IndexMonitorBufferingElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.impl.Futures;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class RefreshingElasticsearchWorkExecutionContext
extends IndexMonitorBufferingElasticsearchWorkExecutionContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkProcessor workProcessor;
    private final Set<URLEncodedString> dirtyIndexes = new HashSet<URLEncodedString>();

    public RefreshingElasticsearchWorkExecutionContext(ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkFactory workFactory, ElasticsearchWorkProcessor workProcessor, ErrorHandler errorHandler) {
        super(client, gsonProvider, errorHandler);
        this.workFactory = workFactory;
        this.workProcessor = workProcessor;
    }

    @Override
    public void setIndexDirty(URLEncodedString indexName) {
        this.dirtyIndexes.add(indexName);
    }

    @Override
    public CompletableFuture<Void> flush() {
        CompletionStage<Void> future = super.flush();
        if (!this.dirtyIndexes.isEmpty()) {
            future = ((CompletableFuture)future.thenCompose(ignored -> this.refreshDirtyIndexes())).thenRun(() -> this.dirtyIndexes.clear());
        }
        return future;
    }

    private CompletableFuture<?> refreshDirtyIndexes() {
        if (log.isTraceEnabled()) {
            log.tracef("Refreshing index(es) %s", this.dirtyIndexes);
        }
        RefreshWorkBuilder builder = this.workFactory.refresh();
        for (URLEncodedString index : this.dirtyIndexes) {
            builder.index(index);
        }
        Object work = builder.build();
        return this.workProcessor.executeAsyncUnsafe(work).handle(Futures.handler((result, throwable) -> {
            if (throwable != null) {
                this.errorHandler.handleException("Refresh failed", throwable);
            }
            return null;
        }));
    }
}

