/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Objects;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch2SchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch50SchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ValidationContextType;
import org.hibernate.search.elasticsearch.schema.impl.ValidationErrorCollector;
import org.hibernate.search.elasticsearch.schema.impl.json.AnalysisParameterEquivalenceRegistry;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;

public class Elasticsearch52SchemaValidator
extends Elasticsearch50SchemaValidator {
    private static final AnalysisParameterEquivalenceRegistry NORMALIZER_EQUIVALENCES = new AnalysisParameterEquivalenceRegistry.Builder().build();
    private final Elasticsearch2SchemaValidator.Validator<NormalizerDefinition> normalizerDefinitionValidator = new NormalizerDefinitionValidator(NORMALIZER_EQUIVALENCES);

    public Elasticsearch52SchemaValidator(ElasticsearchSchemaAccessor schemaAccessor) {
        super(schemaAccessor);
    }

    @Override
    protected String formatContextElement(ValidationContextType type, String name) {
        if (ValidationContextType.NORMALIZER.equals((Object)type)) {
            return MESSAGES.normalizerContext(name);
        }
        return super.formatContextElement(type, name);
    }

    @Override
    protected void validateAnalysisSettings(ValidationErrorCollector errorCollector, IndexSettings.Analysis expectedAnalysis, IndexSettings.Analysis actualAnalysis) {
        super.validateAnalysisSettings(errorCollector, expectedAnalysis, actualAnalysis);
        this.validateAll(errorCollector, ValidationContextType.NORMALIZER, MESSAGES.normalizerMissing(), this.normalizerDefinitionValidator, expectedAnalysis.getNormalizers(), actualAnalysis == null ? null : actualAnalysis.getNormalizers());
    }

    @Override
    protected void validateAnalyzerOptions(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        super.validateAnalyzerOptions(errorCollector, expectedMapping, actualMapping);
        this.validateEqualWithDefault(errorCollector, "normalizer", expectedMapping.getNormalizer(), actualMapping.getNormalizer(), null);
    }

    private class NormalizerDefinitionValidator
    extends Elasticsearch2SchemaValidator.AnalysisDefinitionValidator<NormalizerDefinition> {
        public NormalizerDefinitionValidator(AnalysisParameterEquivalenceRegistry equivalences) {
            super(equivalences);
        }

        @Override
        public void validate(ValidationErrorCollector errorCollector, NormalizerDefinition expectedDefinition, NormalizerDefinition actualDefinition) {
            super.validate(errorCollector, expectedDefinition, actualDefinition);
            if (!Objects.equals(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters())) {
                errorCollector.addError(Elasticsearch2SchemaValidator.MESSAGES.invalidAnalyzerCharFilters(expectedDefinition.getCharFilters(), actualDefinition.getCharFilters()));
            }
            if (!Objects.equals(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters())) {
                errorCollector.addError(Elasticsearch2SchemaValidator.MESSAGES.invalidAnalyzerTokenFilters(expectedDefinition.getTokenFilters(), actualDefinition.getTokenFilters()));
            }
        }
    }
}

