/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryRemove;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryUpdateJndiHandler;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryWriteAttributeHandler;

public class ConnectionFactoryDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = ConnectionFactoryDefinition.concat(ConnectionFactoryAttributes.Regular.ATTRIBUTES, ConnectionFactoryAttribute.getDefinitions(ConnectionFactoryAttributes.Common.ATTRIBUTES));
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{ConnectionFactoryAttributes.Regular.INITIAL_MESSAGE_PACKET_SIZE};
    private final boolean registerRuntimeOnly;
    public static final ConnectionFactoryDefinition INSTANCE = new ConnectionFactoryDefinition(false);

    static final AttributeDefinition[] concat(AttributeDefinition[] common, AttributeDefinition ... specific) {
        int size = common.length + specific.length;
        AttributeDefinition[] result = new AttributeDefinition[size];
        System.arraycopy(common, 0, result, 0, common.length);
        System.arraycopy(specific, 0, result, common.length, specific.length);
        return result;
    }

    public ConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory"), (OperationStepHandler)ConnectionFactoryAdd.INSTANCE, (OperationStepHandler)ConnectionFactoryRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)ConnectionFactoryWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)ConnectionFactoryReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

