/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobContainerPublicAccessType;
import com.microsoft.azure.storage.blob.BlobListingContext;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.BlockListingFilter;
import com.microsoft.azure.storage.blob.ContainerListingDetails;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.LeaseAction;
import com.microsoft.azure.storage.blob.PageOperationType;
import com.microsoft.azure.storage.blob.PageRange;
import com.microsoft.azure.storage.core.BaseRequest;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

final class BlobRequest {
    private static final String APPEND_BLOCK_QUERY_ELEMENT_NAME = "appendblock";
    private static final String BLOCK_QUERY_ELEMENT_NAME = "block";
    private static final String BLOCK_ID_QUERY_ELEMENT_NAME = "blockid";
    private static final String BLOCK_LIST_QUERY_ELEMENT_NAME = "blocklist";
    private static final String BLOCK_LIST_TYPE_QUERY_ELEMENT_NAME = "blocklisttype";
    private static final String COPY_QUERY_ELEMENT_NAME = "copy";
    private static final String PAGE_QUERY_ELEMENT_NAME = "page";
    private static final String PAGE_LIST_QUERY_ELEMENT_NAME = "pagelist";
    private static final String SNAPSHOTS_QUERY_ELEMENT_NAME = "snapshots";
    private static final String UNCOMMITTED_BLOBS_QUERY_ELEMENT_NAME = "uncommittedblobs";

    public static HttpURLConnection abortCopy(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String copyId) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", COPY_QUERY_ELEMENT_NAME);
        builder.add("copyid", copyId);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, blobOptions, builder, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-action", "abort");
        if (accessCondition != null) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    public static void addMetadata(HttpURLConnection request, HashMap<String, String> metadata, OperationContext opContext) {
        BaseRequest.addMetadata(request, metadata, opContext);
    }

    private static void addProperties(HttpURLConnection request, BlobProperties properties) {
        BaseRequest.addOptionalHeader(request, "x-ms-blob-cache-control", properties.getCacheControl());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-disposition", properties.getContentDisposition());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-encoding", properties.getContentEncoding());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-language", properties.getContentLanguage());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-md5", properties.getContentMD5());
        BaseRequest.addOptionalHeader(request, "x-ms-blob-content-type", properties.getContentType());
    }

    private static void addSnapshot(UriQueryBuilder builder, String snapshotVersion) throws StorageException {
        if (snapshotVersion != null) {
            builder.add("snapshot", snapshotVersion);
        }
    }

    public static HttpURLConnection appendBlock(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", APPEND_BLOCK_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
            accessCondition.applyAppendConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection copyFrom(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, String source, String sourceSnapshotID) throws StorageException, IOException, URISyntaxException {
        if (sourceSnapshotID != null) {
            source = source.concat("?snapshot=");
            source = source.concat(sourceSnapshotID);
        }
        HttpURLConnection request = BaseRequest.createURLConnection(uri, blobOptions, null, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setRequestProperty("x-ms-copy-source", source);
        if (sourceAccessCondition != null) {
            sourceAccessCondition.applySourceConditionToRequest(request);
        }
        if (destinationAccessCondition != null) {
            destinationAccessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection createContainer(URI uri, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = BlobRequest.getContainerUriQueryBuilder();
        return BaseRequest.create(uri, blobOptions, containerBuilder, opContext);
    }

    private static HttpURLConnection createURLConnection(URI uri, UriQueryBuilder query, BlobRequestOptions blobOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return BaseRequest.createURLConnection(uri, blobOptions, query, opContext);
    }

    public static HttpURLConnection deleteBlob(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion, DeleteSnapshotsOption deleteSnapshotsOption) throws IOException, URISyntaxException, StorageException {
        if (snapshotVersion != null && deleteSnapshotsOption != DeleteSnapshotsOption.NONE) {
            throw new IllegalArgumentException(String.format("The option '%s' must be 'None' to delete a specific snapshot specified by '%s'.", "deleteSnapshotsOption", "snapshot"));
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        BlobRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.delete(uri, blobOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        switch (deleteSnapshotsOption) {
            case NONE: {
                break;
            }
            case INCLUDE_SNAPSHOTS: {
                request.setRequestProperty("x-ms-delete-snapshots", "include");
                break;
            }
            case DELETE_SNAPSHOTS_ONLY: {
                request.setRequestProperty("x-ms-delete-snapshots", "only");
                break;
            }
        }
        return request;
    }

    public static HttpURLConnection deleteContainer(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = BlobRequest.getContainerUriQueryBuilder();
        HttpURLConnection request = BaseRequest.delete(uri, blobOptions, containerBuilder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getAcl(URI uri, BlobRequestOptions blobOptions, AccessCondition accessCondition, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = BlobRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getBlob(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion, Long offset, Long count, boolean requestRangeContentMD5) throws IOException, URISyntaxException, StorageException {
        if (offset != null && requestRangeContentMD5) {
            Utility.assertNotNull("count", count);
            Utility.assertInBounds("count", count, 1L, Constants.MAX_BLOCK_SIZE);
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        BlobRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, blobOptions, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (offset != null) {
            long rangeStart = offset;
            if (count != null) {
                long rangeEnd = offset + count - 1L;
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-%d", rangeStart, rangeEnd));
            } else {
                request.setRequestProperty("x-ms-range", String.format(Utility.LOCALE_US, "bytes=%d-", rangeStart));
            }
        }
        if (offset != null && requestRangeContentMD5) {
            request.setRequestProperty("x-ms-range-get-content-md5", "true");
        }
        return request;
    }

    public static HttpURLConnection getBlobProperties(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        BlobRequest.addSnapshot(builder, snapshotVersion);
        return BlobRequest.getProperties(uri, blobOptions, opContext, accessCondition, builder);
    }

    public static HttpURLConnection getBlockList(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion, BlockListingFilter blockFilter) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_LIST_QUERY_ELEMENT_NAME);
        builder.add(BLOCK_LIST_TYPE_QUERY_ELEMENT_NAME, blockFilter.toString());
        BlobRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BaseRequest.createURLConnection(uri, blobOptions, builder, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection getContainerProperties(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = BlobRequest.getContainerUriQueryBuilder();
        return BlobRequest.getProperties(uri, blobOptions, opContext, accessCondition, containerBuilder);
    }

    private static UriQueryBuilder getContainerUriQueryBuilder() throws StorageException {
        UriQueryBuilder uriBuilder = new UriQueryBuilder();
        try {
            uriBuilder.add("restype", "container");
        }
        catch (IllegalArgumentException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        return uriBuilder;
    }

    public static HttpURLConnection getPageRanges(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String snapshotVersion) throws StorageException, IOException, URISyntaxException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", PAGE_LIST_QUERY_ELEMENT_NAME);
        BlobRequest.addSnapshot(builder, snapshotVersion);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BaseRequest.addOptionalHeader(request, "snapshot", snapshotVersion);
        return request;
    }

    private static HttpURLConnection getProperties(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, UriQueryBuilder builder) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.getProperties(uri, blobOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    private static HttpURLConnection lease(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds, UriQueryBuilder builder) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        request.setFixedLengthStreamingMode(0);
        request.setRequestProperty("x-ms-lease-action", action.toString());
        if (action == LeaseAction.ACQUIRE) {
            if (leaseTimeInSeconds != null && leaseTimeInSeconds != -1) {
                Utility.assertInBounds("leaseTimeInSeconds", leaseTimeInSeconds.intValue(), 15L, 60L);
            }
            request.setRequestProperty("x-ms-lease-duration", leaseTimeInSeconds == null ? "-1" : leaseTimeInSeconds.toString());
        }
        if (proposedLeaseId != null) {
            request.setRequestProperty("x-ms-proposed-lease-id", proposedLeaseId);
        }
        if (breakPeriodInSeconds != null) {
            Utility.assertInBounds("breakPeriodInSeconds", breakPeriodInSeconds.intValue(), 0L, 60L);
            request.setRequestProperty("x-ms-lease-break-period", breakPeriodInSeconds.toString());
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection leaseBlob(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "lease");
        return BlobRequest.lease(uri, blobOptions, opContext, accessCondition, action, leaseTimeInSeconds, proposedLeaseId, breakPeriodInSeconds, builder);
    }

    public static HttpURLConnection leaseContainer(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, LeaseAction action, Integer leaseTimeInSeconds, String proposedLeaseId, Integer breakPeriodInSeconds) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = BlobRequest.getContainerUriQueryBuilder();
        builder.add("comp", "lease");
        return BlobRequest.lease(uri, blobOptions, opContext, accessCondition, action, leaseTimeInSeconds, proposedLeaseId, breakPeriodInSeconds, builder);
    }

    public static HttpURLConnection listBlobs(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, BlobListingContext listingContext) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = BlobRequest.getContainerUriQueryBuilder();
        builder.add("comp", "list");
        if (listingContext != null) {
            if (!Utility.isNullOrEmpty(listingContext.getPrefix())) {
                builder.add("prefix", listingContext.getPrefix());
            }
            if (!Utility.isNullOrEmpty(listingContext.getDelimiter())) {
                builder.add("delimiter", listingContext.getDelimiter());
            }
            if (!Utility.isNullOrEmpty(listingContext.getMarker())) {
                builder.add("marker", listingContext.getMarker());
            }
            if (listingContext.getMaxResults() != null && listingContext.getMaxResults() > 0) {
                builder.add("maxresults", listingContext.getMaxResults().toString());
            }
            if (listingContext.getListingDetails() != null && listingContext.getListingDetails().size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean started = false;
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.SNAPSHOTS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(SNAPSHOTS_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.UNCOMMITTED_BLOBS)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(UNCOMMITTED_BLOBS_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.COPY)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append(COPY_QUERY_ELEMENT_NAME);
                }
                if (listingContext.getListingDetails().contains((Object)BlobListingDetails.METADATA)) {
                    if (!started) {
                        started = true;
                    } else {
                        sb.append(",");
                    }
                    sb.append("metadata");
                }
                builder.add("include", sb.toString());
            }
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection listContainers(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, ListingContext listingContext, ContainerListingDetails detailsIncluded) throws URISyntaxException, IOException, StorageException {
        UriQueryBuilder builder = BaseRequest.getListUriQueryBuilder(listingContext);
        if (detailsIncluded == ContainerListingDetails.ALL || detailsIncluded == ContainerListingDetails.METADATA) {
            builder.add("include", "metadata");
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setRequestMethod("GET");
        return request;
    }

    public static HttpURLConnection putBlob(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, BlobProperties properties, BlobType blobType, long pageBlobSize) throws IOException, URISyntaxException, StorageException {
        if (blobType == BlobType.UNSPECIFIED) {
            throw new IllegalArgumentException("The blob type is not defined.  Allowed types are BlobType.BLOCK_BLOB and BlobType.Page_BLOB.");
        }
        HttpURLConnection request = BlobRequest.createURLConnection(uri, null, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        BlobRequest.addProperties(request, properties);
        if (blobType == BlobType.PAGE_BLOB) {
            request.setFixedLengthStreamingMode(0);
            request.setRequestProperty("Content-Length", "0");
            request.setRequestProperty("x-ms-blob-type", "PageBlob");
            request.setRequestProperty("x-ms-blob-content-length", String.valueOf(pageBlobSize));
            properties.setLength(pageBlobSize);
        } else if (blobType == BlobType.BLOCK_BLOB) {
            request.setRequestProperty("x-ms-blob-type", "BlockBlob");
        } else if (blobType == BlobType.APPEND_BLOB) {
            request.setFixedLengthStreamingMode(0);
            request.setRequestProperty("x-ms-blob-type", "AppendBlob");
            request.setRequestProperty("Content-Length", "0");
        }
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlock(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, String blockId) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_QUERY_ELEMENT_NAME);
        builder.add(BLOCK_ID_QUERY_ELEMENT_NAME, blockId);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection putBlockList(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, BlobProperties properties) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", BLOCK_LIST_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        BlobRequest.addProperties(request, properties);
        return request;
    }

    public static HttpURLConnection putPage(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, PageRange pageRange, PageOperationType operationType) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", PAGE_QUERY_ELEMENT_NAME);
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (operationType == PageOperationType.CLEAR) {
            request.setFixedLengthStreamingMode(0);
        }
        request.setRequestProperty("x-ms-page-write", operationType.toString());
        request.setRequestProperty("x-ms-range", pageRange.toString());
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
            accessCondition.applySequenceConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection resize(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, Long newBlobSize) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (newBlobSize != null) {
            request.setRequestProperty("x-ms-blob-content-length", newBlobSize.toString());
        }
        return request;
    }

    public static HttpURLConnection setAcl(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, BlobContainerPublicAccessType publicAccess) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = BlobRequest.getContainerUriQueryBuilder();
        builder.add("comp", "acl");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setRequestMethod("PUT");
        request.setDoOutput(true);
        if (publicAccess != BlobContainerPublicAccessType.OFF) {
            request.setRequestProperty("x-ms-blob-public-access", publicAccess.toString().toLowerCase());
        }
        if (accessCondition != null) {
            accessCondition.applyLeaseConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection setBlobMetadata(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        return BlobRequest.setMetadata(uri, blobOptions, opContext, accessCondition, null);
    }

    public static HttpURLConnection setBlobProperties(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, BlobProperties properties) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "properties");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        if (properties != null) {
            BlobRequest.addProperties(request, properties);
        }
        return request;
    }

    public static HttpURLConnection setContainerMetadata(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder containerBuilder = BlobRequest.getContainerUriQueryBuilder();
        return BlobRequest.setMetadata(uri, blobOptions, opContext, accessCondition, containerBuilder);
    }

    private static HttpURLConnection setMetadata(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition, UriQueryBuilder builder) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection request = BaseRequest.setMetadata(uri, blobOptions, builder, opContext);
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    public static HttpURLConnection snapshot(URI uri, BlobRequestOptions blobOptions, OperationContext opContext, AccessCondition accessCondition) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("comp", "snapshot");
        HttpURLConnection request = BlobRequest.createURLConnection(uri, builder, blobOptions, opContext);
        request.setFixedLengthStreamingMode(0);
        request.setDoOutput(true);
        request.setRequestMethod("PUT");
        if (accessCondition != null) {
            accessCondition.applyConditionToRequest(request);
        }
        return request;
    }

    private BlobRequest() {
    }
}

