/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class SimpleAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private Object value;
    private String op;

    public SimpleAuditExpression(PropertyNameGetter propertyNameGetter, Object value, String op) {
        this.propertyNameGetter = propertyNameGetter;
        this.value = value;
        this.op = op;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(enversService, entityName, propertyName);
        if (relatedEntity == null) {
            parameters.addWhereWithParam(propertyName, this.op, this.value);
        } else {
            if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                throw new AuditException("This type of operation: " + this.op + " (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
            }
            Object id = relatedEntity.getIdMapper().mapToIdFromEntity(this.value);
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, id, null, "=".equals(this.op));
        }
    }
}

