/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Table;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Implementation of total order protocol using a sequencer (unicast-unicast-multicast)")
public class SEQUENCER2
extends Protocol {
    protected Address local_addr;
    protected volatile Address coord;
    protected volatile View view;
    protected volatile boolean is_coord = false;
    protected final AtomicLong seqno = new AtomicLong(0L);
    protected final BlockingQueue<Message> fwd_queue = new LinkedBlockingQueue<Message>(20000);
    protected final AtomicInteger seqno_reqs = new AtomicInteger(0);
    protected volatile boolean running = true;
    protected static final BiConsumer<MessageBatch, Message> BATCH_ACCUMULATOR = MessageBatch::add;
    @ManagedAttribute
    protected long request_msgs;
    @ManagedAttribute
    protected long response_msgs;
    @ManagedAttribute
    protected long bcasts_sent;
    @ManagedAttribute
    protected long bcasts_received;
    @ManagedAttribute
    protected long bcasts_delivered;
    @ManagedAttribute
    protected long sent_requests;
    @ManagedAttribute
    protected long received_requests;
    @ManagedAttribute
    protected long sent_responses;
    @ManagedAttribute
    protected long received_responses;
    protected Table<Message> received_msgs = new Table();

    @ManagedAttribute
    public boolean isCoordinator() {
        return this.is_coord;
    }

    public Address getCoordinator() {
        return this.coord;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    @ManagedAttribute(description="Number of messages in the forward-queue")
    public int getFwdQueueSize() {
        return this.fwd_queue.size();
    }

    @Override
    @ManagedOperation
    public void resetStats() {
        this.bcasts_delivered = 0L;
        this.bcasts_received = 0L;
        this.bcasts_sent = 0L;
        this.response_msgs = 0L;
        this.request_msgs = 0L;
        this.received_responses = 0L;
        this.sent_responses = 0L;
        this.received_requests = 0L;
        this.sent_requests = 0L;
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 15: {
                this.handleTmpView((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (msg.getDest() != null || msg.isFlagSet(Message.Flag.NO_TOTAL_ORDER) || msg.isFlagSet(Message.Flag.OOB)) {
            return this.down_prot.down(msg);
        }
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        try {
            this.fwd_queue.put(msg);
            if (this.seqno_reqs.getAndIncrement() == 0) {
                int num_reqs = this.seqno_reqs.get();
                this.sendSeqnoRequest(num_reqs);
            }
        }
        catch (InterruptedException e) {
            if (!this.running) {
                return null;
            }
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object retval = this.up_prot.up(evt);
                this.handleViewChange((View)evt.getArg());
                return retval;
            }
            case 15: {
                this.handleTmpView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        if (msg.isFlagSet(Message.Flag.NO_TOTAL_ORDER) || msg.isFlagSet(Message.Flag.OOB)) {
            return this.up_prot.up(msg);
        }
        SequencerHeader hdr = (SequencerHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        switch (hdr.type) {
            case 1: {
                if (!this.is_coord) {
                    this.log.error("%s: non-coord; dropping REQUEST request from %s", this.local_addr, msg.getSrc());
                    return null;
                }
                Address sender = msg.getSrc();
                if (this.view != null && !this.view.containsMember(sender)) {
                    this.log.error("%s : dropping REQUEST from non-member %s; view=%s" + this.view, this.local_addr, sender, this.view);
                    return null;
                }
                long new_seqno = this.seqno.getAndAdd(hdr.num_seqnos) + 1L;
                this.sendSeqnoResponse(sender, new_seqno, hdr.num_seqnos);
                ++this.received_requests;
                break;
            }
            case 3: {
                Address coordinator = msg.getSrc();
                if (this.view != null && !this.view.containsMember(coordinator)) {
                    this.log.error(this.local_addr + "%s: dropping RESPONSE from non-coordinator %s; view=%s", this.local_addr, coordinator, this.view);
                    return null;
                }
                long send_seqno = hdr.seqno;
                for (int i = 0; i < hdr.num_seqnos; ++i) {
                    Message bcast_msg = (Message)this.fwd_queue.poll();
                    if (bcast_msg == null) {
                        this.log.error(Util.getMessage("Received%DSeqnosButFwdqueueIsEmpty"), hdr.num_seqnos);
                        break;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("%s: broadcasting %d", this.local_addr, send_seqno);
                    }
                    this.broadcast(bcast_msg, send_seqno++);
                }
                int num_reqs = 0;
                num_reqs = this.seqno_reqs.addAndGet(-hdr.num_seqnos);
                if (num_reqs <= 0 || num_reqs <= 0) break;
                this.sendSeqnoRequest(num_reqs);
                break;
            }
            case 2: {
                this.deliver(msg, hdr);
                ++this.bcasts_received;
            }
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            if (msg.isFlagSet(Message.Flag.NO_TOTAL_ORDER) || msg.isFlagSet(Message.Flag.OOB) || msg.getHeader(this.id) == null) continue;
            batch.remove(msg);
            try {
                this.up(msg);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedPassingUpMessage"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleViewChange(View v) {
        boolean coord_changed;
        List<Address> mbrs = v.getMembers();
        if (mbrs.isEmpty()) {
            return;
        }
        if (this.view != null && this.view.compareTo(v) >= 0) {
            return;
        }
        this.view = v;
        Address existing_coord = this.coord;
        Address new_coord = mbrs.get(0);
        boolean bl = coord_changed = !Objects.equals(existing_coord, new_coord);
        if (coord_changed && new_coord != null) {
            this.coord = new_coord;
        }
        if (new_coord != null) {
            this.is_coord = new_coord.equals(this.local_addr);
        }
    }

    private void handleTmpView(View v) {
        Address new_coord = v.getCoord();
        if (new_coord != null && !new_coord.equals(this.coord) && this.local_addr != null && this.local_addr.equals(new_coord)) {
            this.handleViewChange(v);
        }
    }

    protected void sendSeqnoRequest(int num_seqnos) {
        Address target = this.coord;
        if (target == null) {
            return;
        }
        SequencerHeader hdr = new SequencerHeader(1, 0L, num_seqnos);
        Message forward_msg = new Message(target).putHeader(this.id, hdr);
        this.down_prot.down(forward_msg);
        ++this.sent_requests;
    }

    protected void sendSeqnoResponse(Address original_sender, long seqno, int num_seqnos) {
        SequencerHeader hdr = new SequencerHeader(3, seqno, num_seqnos);
        Message ucast_msg = new Message(original_sender).putHeader(this.id, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending seqno response to " + original_sender + ":: new_seqno=" + seqno + ", num_seqnos=" + num_seqnos);
        }
        this.down_prot.down(ucast_msg);
        ++this.sent_responses;
    }

    protected void broadcast(Message msg, long seqno) {
        msg.putHeader(this.id, new SequencerHeader(2, seqno));
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": broadcasting ::" + seqno);
        }
        this.down_prot.down(msg);
        ++this.bcasts_sent;
    }

    protected void deliver(Message msg, SequencerHeader hdr) {
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender is null, cannot deliver ::" + hdr.getSeqno());
            }
            return;
        }
        Table<Message> win = this.received_msgs;
        win.add(hdr.seqno, msg);
        this.removeAndDeliver(win, sender);
    }

    protected void removeAndDeliver(Table<Message> win, Address sender) {
        AtomicInteger adders = win.getAdders();
        if (adders.getAndIncrement() != 0) {
            return;
        }
        MessageBatch batch = new MessageBatch(win.size()).dest(this.local_addr).sender(sender).multicast(false);
        Supplier<MessageBatch> batch_creator = () -> batch;
        do {
            try {
                batch.reset();
                win.removeMany(true, 0, null, batch_creator, BATCH_ACCUMULATOR);
            }
            catch (Throwable t) {
                this.log.error("failed removing messages from table for " + sender, t);
            }
            if (batch.isEmpty()) continue;
            this.deliverBatch(batch);
        } while (adders.decrementAndGet() != 0);
    }

    protected void deliverBatch(MessageBatch batch) {
        try {
            if (batch.isEmpty()) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                Message first = batch.first();
                Message last = batch.last();
                StringBuilder sb = new StringBuilder(this.local_addr + ": delivering");
                if (first != null && last != null) {
                    SequencerHeader hdr1 = (SequencerHeader)first.getHeader(this.id);
                    SequencerHeader hdr2 = (SequencerHeader)last.getHeader(this.id);
                    sb.append(" #").append(hdr1.seqno).append(" - #").append(hdr2.seqno);
                }
                sb.append(" (" + batch.size()).append(" messages)");
                this.log.trace(sb);
            }
            this.up_prot.up(batch);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedToDeliverMsg"), this.local_addr, "batch", batch, t);
        }
    }

    public static class SequencerHeader
    extends Header {
        protected static final byte REQUEST = 1;
        protected static final byte BCAST = 2;
        protected static final byte RESPONSE = 3;
        protected byte type;
        protected long seqno;
        protected int num_seqnos = 1;

        public SequencerHeader() {
        }

        public SequencerHeader(byte type) {
            this.type = type;
        }

        public SequencerHeader(byte type, long seqno) {
            this(type, seqno, 1);
        }

        public SequencerHeader(byte type, long seqno, int num_seqnos) {
            this(type);
            this.seqno = seqno;
            this.num_seqnos = num_seqnos;
        }

        @Override
        public short getMagicId() {
            return 86;
        }

        @Override
        public Supplier<? extends Header> create() {
            return SequencerHeader::new;
        }

        public long getSeqno() {
            return this.seqno;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.printType());
            if (this.seqno >= 0L) {
                sb.append(" seqno=" + this.seqno);
            }
            if (this.num_seqnos > 1) {
                sb.append(", num_seqnos=" + this.num_seqnos);
            }
            return sb.toString();
        }

        protected final String printType() {
            switch (this.type) {
                case 1: {
                    return "REQUEST";
                }
                case 2: {
                    return "BCAST";
                }
                case 3: {
                    return "RESPONSE";
                }
            }
            return "n/a";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Bits.writeLong(this.seqno, out);
            out.writeShort(this.num_seqnos);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.seqno = Bits.readLong(in);
            this.num_seqnos = in.readUnsignedShort();
        }

        @Override
        public int serializedSize() {
            return 1 + Bits.size(this.seqno) + 2;
        }
    }
}

