/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.rest.configuration.ConnectionPoolConfigurationBuilder;

@BuiltBy(value=ConnectionPoolConfigurationBuilder.class)
public class ConnectionPoolConfiguration {
    static final AttributeDefinition<Integer> CONNECTION_TIMEOUT = AttributeDefinition.builder((String)"connectionTimeout", (Object)60000).immutable().build();
    static final AttributeDefinition<Integer> MAX_CONNECTIONS_PER_HOST = AttributeDefinition.builder((String)"maxConnectionsPerHostTimeout", (Object)4).immutable().build();
    static final AttributeDefinition<Integer> MAX_TOTAL_CONNECTIONS = AttributeDefinition.builder((String)"maxTotalConnections", (Object)20).immutable().build();
    static final AttributeDefinition<Integer> BUFFER_SIZE = AttributeDefinition.builder((String)"bufferSize", (Object)8192).immutable().build();
    static final AttributeDefinition<Integer> SOCKET_TIMEOUT = AttributeDefinition.builder((String)"socketTimeout", (Object)60000).immutable().build();
    static final AttributeDefinition<Boolean> TCP_NO_DELAY = AttributeDefinition.builder((String)"tcpNoDelay", (Object)true).immutable().build();
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ConnectionPoolConfiguration.class, new AttributeDefinition[]{CONNECTION_TIMEOUT, MAX_CONNECTIONS_PER_HOST, MAX_TOTAL_CONNECTIONS, BUFFER_SIZE, SOCKET_TIMEOUT, TCP_NO_DELAY});
    }

    public ConnectionPoolConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public int connectionTimeout() {
        return (Integer)this.attributes.attribute(CONNECTION_TIMEOUT).get();
    }

    public int maxConnectionsPerHost() {
        return (Integer)this.attributes.attribute(MAX_CONNECTIONS_PER_HOST).get();
    }

    public int maxTotalConnections() {
        return (Integer)this.attributes.attribute(MAX_TOTAL_CONNECTIONS).get();
    }

    public int bufferSize() {
        return (Integer)this.attributes.attribute(BUFFER_SIZE).get();
    }

    public int socketTimeout() {
        return (Integer)this.attributes.attribute(SOCKET_TIMEOUT).get();
    }

    public boolean tcpNoDelay() {
        return (Boolean)this.attributes.attribute(TCP_NO_DELAY).get();
    }

    public String toString() {
        return "ConnectionPoolConfiguration [connectionTimeout=" + this.connectionTimeout() + ", maxConnectionsPerHost=" + this.maxConnectionsPerHost() + ", maxTotalConnections=" + this.maxTotalConnections() + ", bufferSize=" + this.bufferSize() + ", socketTimeout=" + this.socketTimeout() + ", tcpNoDelay=" + this.tcpNoDelay() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPoolConfiguration that = (ConnectionPoolConfiguration)o;
        if (this.connectionTimeout() != that.connectionTimeout()) {
            return false;
        }
        if (this.maxConnectionsPerHost() != that.maxConnectionsPerHost()) {
            return false;
        }
        if (this.maxTotalConnections() != that.maxTotalConnections()) {
            return false;
        }
        if (this.bufferSize() != that.bufferSize()) {
            return false;
        }
        if (this.socketTimeout() != that.socketTimeout()) {
            return false;
        }
        return this.tcpNoDelay() == that.tcpNoDelay();
    }

    public int hashCode() {
        int result = this.connectionTimeout();
        result = 31 * result + this.maxConnectionsPerHost();
        result = 31 * result + this.maxTotalConnections();
        result = 31 * result + this.bufferSize();
        result = 31 * result + this.socketTimeout();
        result = 31 * result + (this.tcpNoDelay() ? 1 : 0);
        return result;
    }
}

