/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManagerStatistics;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableImmutableSession;
import org.wildfly.clustering.web.undertow.session.DistributableSession;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionManager;

public class DistributableSessionManager
implements UndertowSessionManager {
    private static final int MAX_SESSION_ID_GENERATION_ATTEMPTS = 10;
    private final String deploymentName;
    private final SessionListeners listeners;
    private final SessionManager<LocalSessionContext, Batch> manager;
    private final RecordableSessionManagerStatistics statistics;

    public DistributableSessionManager(String deploymentName, SessionManager<LocalSessionContext, Batch> manager, SessionListeners listeners, RecordableSessionManagerStatistics statistics) {
        this.deploymentName = deploymentName;
        this.manager = manager;
        this.listeners = listeners;
        this.statistics = statistics;
    }

    @Override
    public SessionListeners getSessionListeners() {
        return this.listeners;
    }

    @Override
    public SessionManager<LocalSessionContext, Batch> getSessionManager() {
        return this.manager;
    }

    public void start() {
        this.manager.start();
        if (this.statistics != null) {
            this.statistics.reset();
        }
    }

    public void stop() {
        this.manager.stop();
    }

    public io.undertow.server.session.Session createSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            String id = config.findSessionId(exchange);
            if (id == null) {
                int attempts = 0;
                do {
                    if (++attempts <= 10) continue;
                    throw UndertowMessages.MESSAGES.couldNotGenerateUniqueSessionId();
                } while (this.manager.containsSession(id = (String)this.manager.createIdentifier()));
                config.setSessionId(exchange, id);
            }
            Session session = this.manager.createSession(id);
            DistributableSession adapter = new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch());
            this.listeners.sessionCreated((io.undertow.server.session.Session)adapter, exchange);
            if (this.statistics != null) {
                this.statistics.record(adapter);
            }
            return adapter;
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public io.undertow.server.session.Session getSession(HttpServerExchange exchange, SessionConfig config) {
        if (config == null) {
            throw UndertowMessages.MESSAGES.couldNotFindSessionCookieConfig();
        }
        Batcher batcher = this.manager.getBatcher();
        Batch batch = batcher.createBatch();
        try {
            String id = config.findSessionId(exchange);
            if (id == null) {
                batch.close();
                return null;
            }
            try {
                Base64.getUrlDecoder().decode(id);
            }
            catch (IllegalArgumentException e) {
                batch.close();
                return null;
            }
            Session session = this.manager.findSession(id);
            if (session == null) {
                batch.close();
                return null;
            }
            return new DistributableSession(this, (Session<LocalSessionContext>)session, config, batcher.suspendBatch());
        }
        catch (Error | RuntimeException e) {
            batch.discard();
            batch.close();
            throw e;
        }
    }

    public void registerSessionListener(SessionListener listener) {
        this.listeners.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.listeners.removeSessionListener(listener);
    }

    public void setDefaultSessionTimeout(int timeout) {
        this.manager.setDefaultMaxInactiveInterval(Duration.ofSeconds(timeout));
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.manager.getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.manager.getLocalSessions();
    }

    public io.undertow.server.session.Session getSession(String sessionId) {
        Throwable throwable = null;
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.viewSession(sessionId);
            DistributableImmutableSession distributableImmutableSession = session != null ? new DistributableImmutableSession(this, session) : null;
            return distributableImmutableSession;
        }
        catch (Error | RuntimeException e) {
            try {
                batch.discard();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public SessionManagerStatistics getStatistics() {
        return this.statistics;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DistributableSessionManager)) {
            return false;
        }
        DistributableSessionManager manager = (DistributableSessionManager)object;
        return this.deploymentName.equals(manager.getDeploymentName());
    }

    public int hashCode() {
        return this.deploymentName.hashCode();
    }

    public String toString() {
        return this.deploymentName;
    }
}

